/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.flink.util.MdcAwareExecutorService;
import org.apache.flink.util.MdcUtils;

class MdcAwareScheduledExecutorService
extends MdcAwareExecutorService<ScheduledExecutorService>
implements ScheduledExecutorService {
    public MdcAwareScheduledExecutorService(ScheduledExecutorService delegate, Map<String, String> contextData) {
        super(delegate, contextData);
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return ((ScheduledExecutorService)this.delegate).schedule(MdcUtils.wrapRunnable(this.contextData, command), delay, unit);
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        return ((ScheduledExecutorService)this.delegate).schedule(MdcUtils.wrapCallable(this.contextData, callable), delay, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return ((ScheduledExecutorService)this.delegate).scheduleAtFixedRate(MdcUtils.wrapRunnable(this.contextData, command), initialDelay, period, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return ((ScheduledExecutorService)this.delegate).scheduleWithFixedDelay(MdcUtils.wrapRunnable(this.contextData, command), initialDelay, delay, unit);
    }
}

