/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.fs;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.flink.annotation.Internal;
import org.apache.flink.core.fs.ByteBufferReadable;
import org.apache.flink.core.fs.ClosingFSDataInputStream;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.core.fs.SafetyNetCloseableRegistry;
import org.apache.flink.util.Preconditions;

@Internal
public class ByteBufferReadableClosingFSDataInputStream
extends ClosingFSDataInputStream
implements ByteBufferReadable {
    private final ByteBufferReadable inputStream;

    protected ByteBufferReadableClosingFSDataInputStream(FSDataInputStream delegate, SafetyNetCloseableRegistry registry, String debugInfo) throws IOException {
        super(delegate, registry, debugInfo);
        Preconditions.checkArgument(delegate instanceof ByteBufferReadable);
        this.inputStream = (ByteBufferReadable)((Object)delegate);
    }

    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        return this.inputStream.read(byteBuffer);
    }

    @Override
    public int read(long position, ByteBuffer byteBuffer) throws IOException {
        return this.inputStream.read(position, byteBuffer);
    }
}

