/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.configuration;

import java.time.Duration;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.annotation.docs.Documentation;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.MemorySize;

@PublicEvolving
public class JobEventStoreOptions {
    @Documentation.Section(value={"expert_scheduling"})
    public static final ConfigOption<MemorySize> WRITE_BUFFER_SIZE = ConfigOptions.key("job-event.store.write-buffer.size").memoryType().defaultValue(MemorySize.parse((String)"1MB")).withDescription("The size of the write buffer of JobEventStore. The content will be flushed to external file system once the buffer is full");
    @Documentation.Section(value={"expert_scheduling"})
    public static final ConfigOption<Duration> FLUSH_INTERVAL = ConfigOptions.key("job-event.store.write-buffer.flush-interval").durationType().defaultValue(Duration.ofSeconds(1L)).withDescription("The flush interval of JobEventStore write buffers. Buffer contents will be flushed to external file system regularly with regard to this value.");

    private JobEventStoreOptions() {
        throw new UnsupportedOperationException("This class should never be instantiated.");
    }
}

