/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.terminal.local;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.amoro.config.ConfigOption;
import org.apache.amoro.config.ConfigOptions;
import org.apache.amoro.config.Configurations;
import org.apache.amoro.server.AmoroManagementConf;
import org.apache.amoro.server.catalog.CatalogType;
import org.apache.amoro.server.dashboard.utils.DesensitizationUtil;
import org.apache.amoro.server.terminal.SparkContextUtil;
import org.apache.amoro.server.terminal.TerminalSession;
import org.apache.amoro.server.terminal.TerminalSessionFactory;
import org.apache.amoro.server.terminal.local.LocalTerminalSession;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;
import org.apache.amoro.shade.guava32.com.google.common.collect.Lists;
import org.apache.amoro.shade.guava32.com.google.common.collect.Sets;
import org.apache.amoro.table.TableMetaStore;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.internal.SQLConf;

public class LocalSessionFactory
implements TerminalSessionFactory {
    static final Set<String> STATIC_SPARK_CONF = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"spark.sql.extensions"}));
    static final Set<String> EXTERNAL_CONNECTORS = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"iceberg", "paimon"}));
    static final String SPARK_CONF_PREFIX = "spark.";
    public static ConfigOption<Integer> SPARK_CORES = ConfigOptions.key((String)"cores").intType().defaultValue((Object)1);
    SparkSession context = null;
    Configurations conf;
    List<String> sensitiveConfKeys;

    @Override
    public void initialize(Configurations properties) {
        this.conf = properties;
        this.sensitiveConfKeys = Arrays.stream(properties.getString(AmoroManagementConf.TERMINAL_SENSITIVE_CONF_KEYS).split(",")).map(String::trim).collect(Collectors.toList());
    }

    @Override
    public TerminalSession create(TableMetaStore metaStore, Configurations configuration) {
        SparkSession context = this.lazyInitContext();
        SparkSession session = context.cloneSession();
        List catalogs = (List)configuration.get(TerminalSessionFactory.SessionConfigOptions.CATALOGS);
        ArrayList initializeLogs = Lists.newArrayList();
        initializeLogs.add("setup session, session factory: " + LocalSessionFactory.class.getName());
        Map<String, String> sparkConf = SparkContextUtil.getSparkConf(configuration);
        sparkConf.put("spark.sql.mixed-format.refresh-catalog-before-usage", "true");
        Map finallyConf = configuration.toMap();
        catalogs.stream().filter(c -> this.isExternalConnector((String)c, configuration) || this.isExternalMetastore((String)c, configuration)).forEach(c -> this.setHadoopConfigToSparkSession((String)c, session, metaStore));
        for (String key : sparkConf.keySet()) {
            if (STATIC_SPARK_CONF.contains(key)) continue;
            this.updateSessionConf(session, initializeLogs, key, sparkConf.get(key));
            finallyConf.put(key, sparkConf.get(key));
        }
        return new LocalTerminalSession(catalogs, session, initializeLogs, finallyConf);
    }

    private boolean isExternalMetastore(String catalog, Configurations configurations) {
        String metastoreType = ((String)configurations.get(TerminalSessionFactory.SessionConfigOptions.catalogConnector(catalog))).toLowerCase();
        return !metastoreType.equalsIgnoreCase(CatalogType.AMS.name());
    }

    private boolean isExternalConnector(String catalog, Configurations configurations) {
        String connector = ((String)configurations.get(TerminalSessionFactory.SessionConfigOptions.catalogConnector(catalog))).toLowerCase();
        return EXTERNAL_CONNECTORS.contains(connector);
    }

    private void setHadoopConfigToSparkSession(String catalog, SparkSession session, TableMetaStore metaStore) {
        Configuration metaConf = metaStore.getConfiguration();
        for (Map.Entry next : metaConf) {
            session.conf().set("spark.sql.catalog." + catalog + ".hadoop." + (String)next.getKey(), (String)next.getValue());
        }
    }

    private void updateSessionConf(SparkSession session, List<String> logs, String key, String value) {
        session.conf().set(key, value);
        if (this.sensitiveConfKeys.contains(key)) {
            logs.add(key + "  " + DesensitizationUtil.desensitize(value));
        } else {
            logs.add(key + "  " + value);
        }
    }

    protected synchronized SparkSession lazyInitContext() {
        Preconditions.checkNotNull((Object)this.conf);
        if (this.context == null) {
            SparkConf sparkconf = new SparkConf().setAppName("spark-local-context");
            sparkconf.setMaster("local[" + this.conf.getInteger(SPARK_CORES) + "]");
            sparkconf.set(SQLConf.PARTITION_OVERWRITE_MODE().key(), "dynamic");
            sparkconf.set("spark.executor.heartbeatInterval", "100s");
            sparkconf.set("spark.network.timeout", "200s");
            sparkconf.set("spark.sql.extensions", "org.apache.amoro.spark.MixedFormatSparkExtensions,org.apache.iceberg.spark.extensions.IcebergSparkSessionExtensions");
            sparkconf.set("spark.cleaner.referenceTracking", "false");
            for (String key : this.conf.keySet()) {
                if (!key.startsWith(SPARK_CONF_PREFIX)) continue;
                String value = this.conf.getValue(ConfigOptions.key((String)key).stringType().noDefaultValue());
                sparkconf.set(key, value);
            }
            this.context = SparkSession.builder().config(sparkconf).getOrCreate();
        }
        return this.context;
    }
}

