/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.resource;

import java.util.UUID;
import org.apache.amoro.api.OptimizerRegisterInfo;
import org.apache.amoro.resource.Resource;
import org.apache.amoro.server.resource.OptimizerThread;
import org.apache.amoro.shade.guava32.com.google.common.base.MoreObjects;

public class OptimizerInstance
extends Resource {
    private String token;
    private long startTime;
    private long touchTime;

    public OptimizerInstance() {
    }

    public OptimizerInstance(OptimizerRegisterInfo registerInfo, String containerName) {
        super(registerInfo, containerName);
        this.token = UUID.randomUUID().toString();
        this.touchTime = System.currentTimeMillis();
        this.startTime = registerInfo.getStartTime();
    }

    public OptimizerInstance touch() {
        this.touchTime = System.currentTimeMillis();
        return this;
    }

    public String getToken() {
        return this.token;
    }

    public long getTouchTime() {
        return this.touchTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public OptimizerThread getThread(int threadId) {
        return new OptimizerThread(threadId, this);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("token", (Object)this.token).add("startTime", this.startTime).add("touchTime", this.touchTime).toString();
    }
}

