/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.persistence;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.amoro.optimizing.RewriteFilesInput;
import org.apache.amoro.optimizing.RewriteFilesOutput;
import org.apache.amoro.optimizing.RewriteStageTask;
import org.apache.amoro.server.optimizing.TaskRuntime;
import org.apache.amoro.server.persistence.PersistentBase;
import org.apache.amoro.server.persistence.mapper.OptimizingMapper;
import org.apache.amoro.server.utils.CompressUtil;
import org.apache.amoro.utils.SerializationUtil;

public class TaskFilesPersistence {
    private static final DatabasePersistence persistence = new DatabasePersistence();

    public static void persistTaskInputs(long processId, Collection<TaskRuntime<RewriteStageTask>> tasks) {
        persistence.persistTaskInputs(processId, tasks.stream().collect(Collectors.toMap(e -> e.getTaskId().getTaskId(), task -> (RewriteFilesInput)((RewriteStageTask)task.getTaskDescriptor()).getInput())));
    }

    public static Map<Integer, RewriteFilesInput> loadTaskInputs(long processId) {
        List bytes = persistence.getAs(OptimizingMapper.class, mapper -> mapper.selectProcessInputFiles(processId));
        if (bytes == null || bytes.isEmpty()) {
            return Collections.emptyMap();
        }
        return (Map)SerializationUtil.simpleDeserialize((byte[])CompressUtil.unGzip((byte[])bytes.get(0)));
    }

    public static RewriteFilesOutput loadTaskOutput(byte[] content) {
        return (RewriteFilesOutput)SerializationUtil.simpleDeserialize((byte[])content);
    }

    private static class DatabasePersistence
    extends PersistentBase {
        private DatabasePersistence() {
        }

        public void persistTaskInputs(long processId, Map<Integer, RewriteFilesInput> tasks) {
            this.doAs(OptimizingMapper.class, mapper -> mapper.updateProcessInputFiles(processId, tasks));
        }
    }
}

