/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.lineage;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.streaming.api.lineage.LineageEdge;
import org.apache.flink.streaming.api.lineage.LineageGraph;
import org.apache.flink.streaming.api.lineage.LineageVertex;
import org.apache.flink.streaming.api.lineage.SourceLineageVertex;

@Internal
public class DefaultLineageGraph
implements LineageGraph {
    private final List<LineageEdge> lineageEdges;
    private final List<SourceLineageVertex> sources;
    private final List<LineageVertex> sinks;

    private DefaultLineageGraph(List<LineageEdge> lineageEdges) {
        this.lineageEdges = lineageEdges;
        HashSet<SourceLineageVertex> deduplicatedSources = new HashSet<SourceLineageVertex>();
        HashSet<LineageVertex> deduplicatedSinks = new HashSet<LineageVertex>();
        for (LineageEdge lineageEdge : lineageEdges) {
            deduplicatedSources.add(lineageEdge.source());
            deduplicatedSinks.add(lineageEdge.sink());
        }
        this.sources = new ArrayList<SourceLineageVertex>(deduplicatedSources);
        this.sinks = new ArrayList<LineageVertex>(deduplicatedSinks);
    }

    @Override
    public List<SourceLineageVertex> sources() {
        return Collections.unmodifiableList(this.sources);
    }

    @Override
    public List<LineageVertex> sinks() {
        return Collections.unmodifiableList(this.sinks);
    }

    @Override
    public List<LineageEdge> relations() {
        return Collections.unmodifiableList(this.lineageEdges);
    }

    public static LineageGraphBuilder builder() {
        return new LineageGraphBuilder();
    }

    @Internal
    public static class LineageGraphBuilder {
        private final List<LineageEdge> lineageEdges = new ArrayList<LineageEdge>();

        private LineageGraphBuilder() {
        }

        public LineageGraphBuilder addLineageEdge(LineageEdge lineageEdge) {
            this.lineageEdges.add(lineageEdge);
            return this;
        }

        public LineageGraphBuilder addLineageEdges(LineageEdge ... lineageEdges) {
            this.lineageEdges.addAll(Arrays.asList(lineageEdges));
            return this;
        }

        public LineageGraph build() {
            return new DefaultLineageGraph(this.lineageEdges);
        }
    }
}

