/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.data;

import org.apache.avro.generic.GenericData;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.DateTimeUtil;

public class IdentityPartitionConverters {
    private IdentityPartitionConverters() {
    }

    public static Object convertConstant(Type type, Object value) {
        if (value == null) {
            return null;
        }
        switch (type.typeId()) {
            case STRING: {
                return value.toString();
            }
            case TIME: {
                return DateTimeUtil.timeFromMicros((long)((Long)value));
            }
            case DATE: {
                return DateTimeUtil.dateFromDays((int)((Integer)value));
            }
            case TIMESTAMP: {
                if (((Types.TimestampType)type).shouldAdjustToUTC()) {
                    return DateTimeUtil.timestamptzFromMicros((long)((Long)value));
                }
                return DateTimeUtil.timestampFromMicros((long)((Long)value));
            }
            case FIXED: {
                if (value instanceof GenericData.Fixed) {
                    return ((GenericData.Fixed)value).bytes();
                }
                return value;
            }
        }
        return value;
    }
}

