/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.objectinspector.primitive;

import org.apache.hadoop.hive.common.type.Date;
import org.apache.hadoop.hive.serde2.io.DateWritableV2;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveJavaObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableDateObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;

public class JavaDateObjectInspector
extends AbstractPrimitiveJavaObjectInspector
implements SettableDateObjectInspector {
    protected JavaDateObjectInspector() {
        super(TypeInfoFactory.dateTypeInfo);
    }

    @Override
    public DateWritableV2 getPrimitiveWritableObject(Object o) {
        return o == null ? null : new DateWritableV2((Date)o);
    }

    @Override
    public Date getPrimitiveJavaObject(Object o) {
        return o == null ? null : (Date)o;
    }

    public Date get(Object o) {
        return (Date)o;
    }

    @Override
    public Object set(Object o, Date value) {
        if (value == null) {
            return null;
        }
        ((Date)o).setTimeInDays(value.toEpochDay());
        return o;
    }

    @Override
    @Deprecated
    public Object set(Object o, java.sql.Date value) {
        if (value == null) {
            return null;
        }
        ((Date)o).setTimeInMillis(value.getTime());
        return o;
    }

    @Override
    public Object set(Object o, DateWritableV2 d) {
        if (d == null) {
            return null;
        }
        ((Date)o).setTimeInDays(d.get().toEpochDay());
        return o;
    }

    @Override
    @Deprecated
    public Object create(java.sql.Date value) {
        return Date.ofEpochMilli((long)value.getTime());
    }

    @Override
    public Object create(Date value) {
        return Date.ofEpochDay((int)value.toEpochDay());
    }
}

