/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.spark.io;

import java.util.Locale;
import java.util.Map;
import org.apache.amoro.hive.io.writer.AdaptHiveOutputFileFactory;
import org.apache.amoro.hive.table.SupportHive;
import org.apache.amoro.io.writer.ChangeTaskWriter;
import org.apache.amoro.io.writer.CommonOutputFileFactory;
import org.apache.amoro.io.writer.OutputFileFactory;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;
import org.apache.amoro.spark.io.InternalRowFileAppenderFactory;
import org.apache.amoro.spark.io.SparkBaseTaskWriter;
import org.apache.amoro.spark.io.SparkChangeTaskWriter;
import org.apache.amoro.spark.io.UnkeyedUpsertSparkWriter;
import org.apache.amoro.table.BaseTable;
import org.apache.amoro.table.KeyedTable;
import org.apache.amoro.table.MixedTable;
import org.apache.amoro.table.PrimaryKeySpec;
import org.apache.amoro.table.UnkeyedTable;
import org.apache.amoro.utils.SchemaUtil;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.encryption.EncryptionManager;
import org.apache.iceberg.io.TaskWriter;
import org.apache.iceberg.spark.SparkSchemaUtil;
import org.apache.iceberg.util.PropertyUtil;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.types.StructType;

public class TaskWriters {
    private final MixedTable table;
    private Long transactionId;
    private int partitionId = 0;
    private long taskId = 0L;
    private StructType dsSchema;
    private String hiveSubdirectory;
    private boolean orderedWriter = false;
    private final boolean isHiveTable;
    private final FileFormat fileFormat;
    private final long fileSize;
    private final long mask;

    protected TaskWriters(MixedTable table) {
        this.table = table;
        this.isHiveTable = table instanceof SupportHive;
        this.fileFormat = FileFormat.valueOf((String)table.properties().getOrDefault("base.write.format", "parquet").toUpperCase(Locale.ENGLISH));
        this.fileSize = PropertyUtil.propertyAsLong((Map)table.properties(), (String)"write.target-file-size-bytes", (long)0x8000000L);
        this.mask = PropertyUtil.propertyAsLong((Map)table.properties(), (String)"base.file-index.hash-bucket", (long)4L) - 1L;
    }

    public static TaskWriters of(MixedTable table) {
        return new TaskWriters(table);
    }

    public TaskWriters withTransactionId(Long transactionId) {
        this.transactionId = transactionId;
        return this;
    }

    public TaskWriters withPartitionId(int partitionId) {
        this.partitionId = partitionId;
        return this;
    }

    public TaskWriters withTaskId(long taskId) {
        this.taskId = taskId;
        return this;
    }

    public TaskWriters withDataSourceSchema(StructType dsSchema) {
        this.dsSchema = dsSchema;
        return this;
    }

    public TaskWriters withHiveSubdirectory(String hiveSubdirectory) {
        this.hiveSubdirectory = hiveSubdirectory;
        return this;
    }

    public TaskWriters withOrderedWriter(boolean orderedWriter) {
        this.orderedWriter = orderedWriter;
        return this;
    }

    public TaskWriter<InternalRow> newBaseWriter(boolean isOverwrite) {
        UnkeyedTable icebergTable;
        Schema schema;
        EncryptionManager encryptionManager;
        String baseLocation;
        this.preconditions();
        PrimaryKeySpec primaryKeySpec = null;
        if (this.table.isKeyedTable()) {
            KeyedTable keyedTable = this.table.asKeyedTable();
            baseLocation = keyedTable.baseLocation();
            encryptionManager = keyedTable.baseTable().encryption();
            schema = keyedTable.baseTable().schema();
            primaryKeySpec = keyedTable.primaryKeySpec();
            icebergTable = keyedTable.baseTable();
        } else {
            UnkeyedTable table = this.table.asUnkeyedTable();
            baseLocation = table.location();
            encryptionManager = table.encryption();
            schema = table.schema();
            icebergTable = table;
        }
        InternalRowFileAppenderFactory appenderFactory = InternalRowFileAppenderFactory.builderFor((Table)icebergTable, schema, this.dsSchema).writeHive(this.isHiveTable).build();
        boolean hiveConsistentWrite = PropertyUtil.propertyAsBoolean((Map)this.table.properties(), (String)"base.hive.consistent-write.enabled", (boolean)true);
        Object outputFileFactory = this.isHiveTable && isOverwrite ? new AdaptHiveOutputFileFactory(((SupportHive)this.table).hiveLocation(), this.table.spec(), this.fileFormat, this.table.io(), encryptionManager, this.partitionId, this.taskId, this.transactionId, this.hiveSubdirectory, hiveConsistentWrite) : new CommonOutputFileFactory(baseLocation, this.table.spec(), this.fileFormat, this.table.io(), encryptionManager, this.partitionId, this.taskId, this.transactionId);
        return new SparkBaseTaskWriter(this.fileFormat, appenderFactory, (OutputFileFactory)outputFileFactory, this.table.io(), this.fileSize, this.mask, schema, this.table.spec(), primaryKeySpec, this.orderedWriter);
    }

    public ChangeTaskWriter<InternalRow> newChangeWriter() {
        this.preconditions();
        PrimaryKeySpec primaryKeySpec = null;
        if (!this.table.isKeyedTable()) {
            throw new UnsupportedOperationException("Unkeyed table does not support change writer");
        }
        KeyedTable keyedTable = this.table.asKeyedTable();
        String changeLocation = keyedTable.changeLocation();
        EncryptionManager encryptionManager = keyedTable.changeTable().encryption();
        Schema schema = SchemaUtil.changeWriteSchema((Schema)keyedTable.changeTable().schema());
        primaryKeySpec = keyedTable.primaryKeySpec();
        BaseTable icebergTable = keyedTable.baseTable();
        InternalRowFileAppenderFactory appenderFactory = InternalRowFileAppenderFactory.builderFor((Table)icebergTable, schema, SparkSchemaUtil.convert((Schema)schema)).writeHive(this.isHiveTable).build();
        CommonOutputFileFactory outputFileFactory = new CommonOutputFileFactory(changeLocation, this.table.spec(), this.fileFormat, this.table.io(), encryptionManager, this.partitionId, this.taskId, this.transactionId);
        return new SparkChangeTaskWriter(this.fileFormat, appenderFactory, (OutputFileFactory)outputFileFactory, this.table.io(), this.fileSize, this.mask, schema, this.table.spec(), primaryKeySpec, this.orderedWriter);
    }

    public TaskWriter<InternalRow> newUnkeyedUpsertWriter() {
        this.preconditions();
        Schema schema = this.table.schema();
        InternalRowFileAppenderFactory build = new InternalRowFileAppenderFactory.Builder((Table)this.table.asUnkeyedTable(), schema, this.dsSchema).build();
        long fileSizeBytes = PropertyUtil.propertyAsLong((Map)this.table.properties(), (String)"write.target-file-size-bytes", (long)0x8000000L);
        long mask = PropertyUtil.propertyAsLong((Map)this.table.properties(), (String)"base.file-index.hash-bucket", (long)4L) - 1L;
        CommonOutputFileFactory commonOutputFileFactory = new CommonOutputFileFactory(this.table.location(), this.table.spec(), this.fileFormat, this.table.io(), this.table.asUnkeyedTable().encryption(), this.partitionId, this.taskId, this.transactionId);
        SparkBaseTaskWriter sparkBaseTaskWriter = new SparkBaseTaskWriter(this.fileFormat, build, (OutputFileFactory)commonOutputFileFactory, this.table.io(), fileSizeBytes, mask, schema, this.table.spec(), null, this.orderedWriter);
        return new UnkeyedUpsertSparkWriter<InternalRow>(this.table, build, (OutputFileFactory)commonOutputFileFactory, this.fileFormat, schema, sparkBaseTaskWriter);
    }

    private void preconditions() {
        if (this.table.isKeyedTable()) {
            Preconditions.checkState((this.transactionId != null ? 1 : 0) != 0, (Object)"Transaction id is not set for KeyedTable");
        } else {
            Preconditions.checkState((this.transactionId == null ? 1 : 0) != 0, (Object)"Transaction id should be null for UnkeyedTable");
        }
        Preconditions.checkState((this.partitionId >= 0 ? 1 : 0) != 0, (Object)"Partition id is not set");
        Preconditions.checkState((this.taskId >= 0L ? 1 : 0) != 0, (Object)"Task id is not set");
        Preconditions.checkState((this.dsSchema != null ? 1 : 0) != 0, (Object)"Data source schema is not set");
    }
}

