/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.transfer.s3.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;
import software.amazon.awssdk.transfer.s3.model.TransferObjectRequest;
import software.amazon.awssdk.transfer.s3.progress.TransferListener;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.Validate;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@SdkPublicApi
public final class DownloadRequest<ReturnT>
implements TransferObjectRequest,
ToCopyableBuilder<TypedBuilder<ReturnT>, DownloadRequest<ReturnT>> {
    private final AsyncResponseTransformer<GetObjectResponse, ReturnT> responseTransformer;
    private final GetObjectRequest getObjectRequest;
    private final List<TransferListener> transferListeners;

    private DownloadRequest(DefaultTypedBuilder<ReturnT> builder) {
        this.responseTransformer = (AsyncResponseTransformer)Validate.paramNotNull((Object)((DefaultTypedBuilder)builder).responseTransformer, (String)"responseTransformer");
        this.getObjectRequest = (GetObjectRequest)Validate.paramNotNull((Object)((DefaultTypedBuilder)builder).getObjectRequest, (String)"getObjectRequest");
        this.transferListeners = ((DefaultTypedBuilder)builder).transferListeners;
    }

    public static UntypedBuilder builder() {
        return new DefaultUntypedBuilder();
    }

    public TypedBuilder<ReturnT> toBuilder() {
        return new DefaultTypedBuilder(this);
    }

    public AsyncResponseTransformer<GetObjectResponse, ReturnT> responseTransformer() {
        return this.responseTransformer;
    }

    public GetObjectRequest getObjectRequest() {
        return this.getObjectRequest;
    }

    @Override
    public List<TransferListener> transferListeners() {
        return this.transferListeners;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DownloadRequest that = (DownloadRequest)o;
        if (!Objects.equals(this.responseTransformer, that.responseTransformer)) {
            return false;
        }
        if (!Objects.equals(this.getObjectRequest, that.getObjectRequest)) {
            return false;
        }
        return Objects.equals(this.transferListeners, that.transferListeners);
    }

    public int hashCode() {
        int result = this.responseTransformer != null ? this.responseTransformer.hashCode() : 0;
        result = 31 * result + (this.getObjectRequest != null ? this.getObjectRequest.hashCode() : 0);
        result = 31 * result + (this.transferListeners != null ? this.transferListeners.hashCode() : 0);
        return result;
    }

    public String toString() {
        return ToString.builder((String)"DownloadRequest").add("responseTransformer", this.responseTransformer).add("getObjectRequest", (Object)this.getObjectRequest).add("transferListeners", this.transferListeners).build();
    }

    private static class DefaultTypedBuilder<T>
    implements TypedBuilder<T> {
        private GetObjectRequest getObjectRequest;
        private List<TransferListener> transferListeners;
        private AsyncResponseTransformer<GetObjectResponse, T> responseTransformer;

        private DefaultTypedBuilder() {
        }

        private DefaultTypedBuilder(DownloadRequest<T> request) {
            this.getObjectRequest = ((DownloadRequest)request).getObjectRequest;
            this.responseTransformer = ((DownloadRequest)request).responseTransformer;
            this.transferListeners = ((DownloadRequest)request).transferListeners;
        }

        @Override
        public TypedBuilder<T> getObjectRequest(GetObjectRequest getObjectRequest) {
            this.getObjectRequest = getObjectRequest;
            return this;
        }

        @Override
        public TypedBuilder<T> responseTransformer(AsyncResponseTransformer<GetObjectResponse, T> responseTransformer) {
            this.responseTransformer = responseTransformer;
            return this;
        }

        @Override
        public TypedBuilder<T> transferListeners(Collection<TransferListener> transferListeners) {
            this.transferListeners = transferListeners != null ? new ArrayList<TransferListener>(transferListeners) : null;
            return this;
        }

        @Override
        public TypedBuilder<T> addTransferListener(TransferListener transferListener) {
            if (this.transferListeners == null) {
                this.transferListeners = new ArrayList<TransferListener>();
            }
            this.transferListeners.add(transferListener);
            return this;
        }

        public List<TransferListener> getTransferListeners() {
            return this.transferListeners;
        }

        public void setTransferListeners(Collection<TransferListener> transferListeners) {
            this.transferListeners(transferListeners);
        }

        public DownloadRequest<T> build() {
            return new DownloadRequest(this);
        }
    }

    public static interface TypedBuilder<T>
    extends CopyableBuilder<TypedBuilder<T>, DownloadRequest<T>> {
        public TypedBuilder<T> getObjectRequest(GetObjectRequest var1);

        default public TypedBuilder<T> getObjectRequest(Consumer<GetObjectRequest.Builder> getObjectRequestBuilder) {
            GetObjectRequest request = (GetObjectRequest)((GetObjectRequest.Builder)GetObjectRequest.builder().applyMutation(getObjectRequestBuilder)).build();
            this.getObjectRequest(request);
            return this;
        }

        public TypedBuilder<T> transferListeners(Collection<TransferListener> var1);

        public TypedBuilder<T> addTransferListener(TransferListener var1);

        public TypedBuilder<T> responseTransformer(AsyncResponseTransformer<GetObjectResponse, T> var1);
    }

    private static final class DefaultUntypedBuilder
    implements UntypedBuilder {
        private GetObjectRequest getObjectRequest;
        private List<TransferListener> transferListeners;

        private DefaultUntypedBuilder() {
        }

        @Override
        public UntypedBuilder getObjectRequest(GetObjectRequest getObjectRequest) {
            this.getObjectRequest = getObjectRequest;
            return this;
        }

        @Override
        public UntypedBuilder transferListeners(Collection<TransferListener> transferListeners) {
            this.transferListeners = transferListeners != null ? new ArrayList<TransferListener>(transferListeners) : null;
            return this;
        }

        @Override
        public UntypedBuilder addTransferListener(TransferListener transferListener) {
            if (this.transferListeners == null) {
                this.transferListeners = new ArrayList<TransferListener>();
            }
            this.transferListeners.add(transferListener);
            return this;
        }

        public List<TransferListener> getTransferListeners() {
            return this.transferListeners;
        }

        public void setTransferListeners(Collection<TransferListener> transferListeners) {
            this.transferListeners(transferListeners);
        }

        @Override
        public <T> TypedBuilder<T> responseTransformer(AsyncResponseTransformer<GetObjectResponse, T> responseTransformer) {
            return new DefaultTypedBuilder().getObjectRequest(this.getObjectRequest).transferListeners(this.transferListeners).responseTransformer(responseTransformer);
        }
    }

    public static interface UntypedBuilder {
        public UntypedBuilder getObjectRequest(GetObjectRequest var1);

        default public UntypedBuilder getObjectRequest(Consumer<GetObjectRequest.Builder> getObjectRequestBuilder) {
            GetObjectRequest request = (GetObjectRequest)((GetObjectRequest.Builder)GetObjectRequest.builder().applyMutation(getObjectRequestBuilder)).build();
            this.getObjectRequest(request);
            return this;
        }

        public UntypedBuilder transferListeners(Collection<TransferListener> var1);

        public UntypedBuilder addTransferListener(TransferListener var1);

        public <T> TypedBuilder<T> responseTransformer(AsyncResponseTransformer<GetObjectResponse, T> var1);
    }
}

