/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CustomKeyStoreType {
    AWS_CLOUDHSM("AWS_CLOUDHSM"),
    EXTERNAL_KEY_STORE("EXTERNAL_KEY_STORE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CustomKeyStoreType> VALUE_MAP;
    private final String value;

    private CustomKeyStoreType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CustomKeyStoreType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CustomKeyStoreType> knownValues() {
        EnumSet<CustomKeyStoreType> knownValues = EnumSet.allOf(CustomKeyStoreType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CustomKeyStoreType.class, CustomKeyStoreType::toString);
    }
}

