/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.datastream.impl.operators;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.datastream.api.context.NonPartitionedContext;
import org.apache.flink.datastream.api.context.PartitionedContext;
import org.apache.flink.datastream.api.context.ProcessingTimeManager;
import org.apache.flink.datastream.api.function.TwoInputNonBroadcastStreamProcessFunction;
import org.apache.flink.datastream.impl.common.KeyCheckedOutputCollector;
import org.apache.flink.datastream.impl.common.OutputCollector;
import org.apache.flink.datastream.impl.common.TimestampCollector;
import org.apache.flink.datastream.impl.context.DefaultNonPartitionedContext;
import org.apache.flink.datastream.impl.context.DefaultProcessingTimeManager;
import org.apache.flink.datastream.impl.operators.TwoInputNonBroadcastProcessOperator;
import org.apache.flink.runtime.state.VoidNamespace;
import org.apache.flink.runtime.state.VoidNamespaceSerializer;
import org.apache.flink.streaming.api.operators.InternalTimer;
import org.apache.flink.streaming.api.operators.InternalTimerService;
import org.apache.flink.streaming.api.operators.Triggerable;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;

public class KeyedTwoInputNonBroadcastProcessOperator<KEY, IN1, IN2, OUT>
extends TwoInputNonBroadcastProcessOperator<IN1, IN2, OUT>
implements Triggerable<KEY, VoidNamespace> {
    private transient InternalTimerService<VoidNamespace> timerService;
    private transient Set<Object> keySet;
    @Nullable
    private final KeySelector<OUT, KEY> outKeySelector;

    public KeyedTwoInputNonBroadcastProcessOperator(TwoInputNonBroadcastStreamProcessFunction<IN1, IN2, OUT> userFunction) {
        this(userFunction, null);
    }

    public KeyedTwoInputNonBroadcastProcessOperator(TwoInputNonBroadcastStreamProcessFunction<IN1, IN2, OUT> userFunction, @Nullable KeySelector<OUT, KEY> outKeySelector) {
        super(userFunction);
        this.outKeySelector = outKeySelector;
    }

    @Override
    public void open() throws Exception {
        this.timerService = this.getInternalTimerService("processing timer", (TypeSerializer)VoidNamespaceSerializer.INSTANCE, this);
        this.keySet = new HashSet<Object>();
        super.open();
    }

    @Override
    protected TimestampCollector<OUT> getOutputCollector() {
        return this.outKeySelector == null ? new OutputCollector(this.output) : new KeyCheckedOutputCollector(new OutputCollector(this.output), this.outKeySelector, () -> this.getCurrentKey());
    }

    @Override
    protected Object currentKey() {
        return this.getCurrentKey();
    }

    @Override
    protected ProcessingTimeManager getProcessingTimeManager() {
        return new DefaultProcessingTimeManager(this.timerService);
    }

    public void onEventTime(InternalTimer<KEY, VoidNamespace> timer) throws Exception {
    }

    public void onProcessingTime(InternalTimer<KEY, VoidNamespace> timer) throws Exception {
        this.partitionedContext.getStateManager().executeInKeyContext(() -> ((TwoInputNonBroadcastStreamProcessFunction)this.userFunction).onProcessingTimer(timer.getTimestamp(), this.getOutputCollector(), (PartitionedContext)this.partitionedContext), timer.getKey());
    }

    @Override
    protected NonPartitionedContext<OUT> getNonPartitionedContext() {
        return new DefaultNonPartitionedContext(this.context, this.partitionedContext, this.collector, true, this.keySet);
    }

    public void setKeyContextElement1(StreamRecord record) throws Exception {
        this.setKeyContextElement(record, this.getStateKeySelector1());
    }

    public void setKeyContextElement2(StreamRecord record) throws Exception {
        this.setKeyContextElement(record, this.getStateKeySelector2());
    }

    private <T> void setKeyContextElement(StreamRecord<T> record, KeySelector<T, ?> selector) throws Exception {
        if (selector == null) {
            return;
        }
        Object key = selector.getKey(record.getValue());
        this.setCurrentKey(key);
        this.keySet.add(key);
    }
}

