/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.datastream.impl.context;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.flink.api.common.state.AggregatingState;
import org.apache.flink.api.common.state.AggregatingStateDeclaration;
import org.apache.flink.api.common.state.AggregatingStateDescriptor;
import org.apache.flink.api.common.state.BroadcastState;
import org.apache.flink.api.common.state.BroadcastStateDeclaration;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.api.common.state.ListStateDeclaration;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.state.MapState;
import org.apache.flink.api.common.state.MapStateDeclaration;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.state.OperatorStateStore;
import org.apache.flink.api.common.state.ReducingState;
import org.apache.flink.api.common.state.ReducingStateDeclaration;
import org.apache.flink.api.common.state.ReducingStateDescriptor;
import org.apache.flink.api.common.state.StateDeclaration;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDeclaration;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.datastream.api.context.StateManager;
import org.apache.flink.streaming.api.operators.StreamingRuntimeContext;
import org.apache.flink.util.Preconditions;

public class DefaultStateManager
implements StateManager {
    private final Supplier<Object> currentKeySupplier;
    private final Consumer<Object> currentKeySetter;
    protected final StreamingRuntimeContext operatorContext;
    protected final OperatorStateStore operatorStateStore;

    public DefaultStateManager(Supplier<Object> currentKeySupplier, Consumer<Object> currentKeySetter, StreamingRuntimeContext operatorContext, OperatorStateStore operatorStateStore) {
        this.currentKeySupplier = currentKeySupplier;
        this.currentKeySetter = currentKeySetter;
        this.operatorContext = (StreamingRuntimeContext)Preconditions.checkNotNull((Object)operatorContext);
        this.operatorStateStore = (OperatorStateStore)Preconditions.checkNotNull((Object)operatorStateStore);
    }

    public <K> K getCurrentKey() {
        return (K)this.currentKeySupplier.get();
    }

    public <T> Optional<ValueState<T>> getState(ValueStateDeclaration<T> stateDeclaration) throws Exception {
        ValueStateDescriptor valueStateDescriptor = new ValueStateDescriptor(stateDeclaration.getName(), stateDeclaration.getTypeDescriptor().getTypeClass());
        return Optional.ofNullable(this.operatorContext.getState(valueStateDescriptor));
    }

    public <T> Optional<ListState<T>> getState(ListStateDeclaration<T> stateDeclaration) throws Exception {
        ListStateDescriptor listStateDescriptor = new ListStateDescriptor(stateDeclaration.getName(), stateDeclaration.getTypeDescriptor().getTypeClass());
        if (stateDeclaration.getRedistributionMode() == StateDeclaration.RedistributionMode.REDISTRIBUTABLE) {
            if (stateDeclaration.getRedistributionStrategy() == ListStateDeclaration.RedistributionStrategy.UNION) {
                return Optional.ofNullable(this.operatorStateStore.getUnionListState(listStateDescriptor));
            }
            return Optional.ofNullable(this.operatorStateStore.getListState(listStateDescriptor));
        }
        return Optional.ofNullable(this.operatorContext.getListState(listStateDescriptor));
    }

    public <K, V> Optional<MapState<K, V>> getState(MapStateDeclaration<K, V> stateDeclaration) throws Exception {
        MapStateDescriptor mapStateDescriptor = new MapStateDescriptor(stateDeclaration.getName(), stateDeclaration.getKeyTypeDescriptor().getTypeClass(), stateDeclaration.getValueTypeDescriptor().getTypeClass());
        return Optional.ofNullable(this.operatorContext.getMapState(mapStateDescriptor));
    }

    public <T> Optional<ReducingState<T>> getState(ReducingStateDeclaration<T> stateDeclaration) throws Exception {
        ReducingStateDescriptor reducingStateDescriptor = new ReducingStateDescriptor(stateDeclaration.getName(), stateDeclaration.getReduceFunction(), stateDeclaration.getTypeDescriptor().getTypeClass());
        return Optional.ofNullable(this.operatorContext.getReducingState(reducingStateDescriptor));
    }

    public <IN, ACC, OUT> Optional<AggregatingState<IN, OUT>> getState(AggregatingStateDeclaration<IN, ACC, OUT> stateDeclaration) throws Exception {
        AggregatingStateDescriptor aggregatingStateDescriptor = new AggregatingStateDescriptor(stateDeclaration.getName(), stateDeclaration.getAggregateFunction(), stateDeclaration.getTypeDescriptor().getTypeClass());
        return Optional.ofNullable(this.operatorContext.getAggregatingState(aggregatingStateDescriptor));
    }

    public <K, V> Optional<BroadcastState<K, V>> getState(BroadcastStateDeclaration<K, V> stateDeclaration) throws Exception {
        MapStateDescriptor mapStateDescriptor = new MapStateDescriptor(stateDeclaration.getName(), stateDeclaration.getKeyTypeDescriptor().getTypeClass(), stateDeclaration.getValueTypeDescriptor().getTypeClass());
        return Optional.ofNullable(this.operatorStateStore.getBroadcastState(mapStateDescriptor));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeInKeyContext(Runnable runnable, Object key) {
        Object oldKey = this.currentKeySupplier.get();
        this.setCurrentKey(key);
        try {
            runnable.run();
        }
        finally {
            this.resetCurrentKey(oldKey);
        }
    }

    private void setCurrentKey(Object key) {
        this.currentKeySetter.accept(key);
    }

    private void resetCurrentKey(Object oldKey) {
        this.currentKeySetter.accept(oldKey);
    }
}

