/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.dispatcher;

import java.util.Collection;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.dispatcher.DispatcherBootstrapFactory;
import org.apache.flink.runtime.dispatcher.DispatcherFactory;
import org.apache.flink.runtime.dispatcher.DispatcherId;
import org.apache.flink.runtime.dispatcher.DispatcherServices;
import org.apache.flink.runtime.dispatcher.JobMasterServiceLeadershipRunnerFactory;
import org.apache.flink.runtime.dispatcher.MiniDispatcher;
import org.apache.flink.runtime.dispatcher.PartialDispatcherServicesWithJobPersistenceComponents;
import org.apache.flink.runtime.dispatcher.cleanup.CheckpointResourcesCleanupRunnerFactory;
import org.apache.flink.runtime.entrypoint.ClusterEntrypoint;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobmaster.JobResult;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.shaded.guava31.com.google.common.collect.Iterables;
import org.apache.flink.util.Preconditions;

public enum JobDispatcherFactory implements DispatcherFactory
{
    INSTANCE;


    @Override
    public MiniDispatcher createDispatcher(RpcService rpcService, DispatcherId fencingToken, Collection<JobGraph> recoveredJobs, Collection<JobResult> recoveredDirtyJobResults, DispatcherBootstrapFactory dispatcherBootstrapFactory, PartialDispatcherServicesWithJobPersistenceComponents partialDispatcherServicesWithJobPersistenceComponents) throws Exception {
        JobGraph recoveredJobGraph = (JobGraph)Iterables.getOnlyElement(recoveredJobs, null);
        JobResult recoveredDirtyJob = (JobResult)Iterables.getOnlyElement(recoveredDirtyJobResults, null);
        Preconditions.checkArgument((boolean)(recoveredJobGraph == null ^ recoveredDirtyJob == null), (Object)"Either the JobGraph or the recovered JobResult needs to be specified.");
        Configuration configuration = partialDispatcherServicesWithJobPersistenceComponents.getConfiguration();
        String executionModeValue = (String)configuration.get(ClusterEntrypoint.INTERNAL_CLUSTER_EXECUTION_MODE);
        ClusterEntrypoint.ExecutionMode executionMode = ClusterEntrypoint.ExecutionMode.valueOf(executionModeValue);
        return new MiniDispatcher(rpcService, fencingToken, DispatcherServices.from(partialDispatcherServicesWithJobPersistenceComponents, JobMasterServiceLeadershipRunnerFactory.INSTANCE, CheckpointResourcesCleanupRunnerFactory.INSTANCE), recoveredJobGraph, recoveredDirtyJob, dispatcherBootstrapFactory, executionMode);
    }
}

