/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.io.writer;

import java.io.IOException;
import org.apache.amoro.data.ChangeAction;
import org.apache.amoro.data.DataFileType;
import org.apache.amoro.io.AuthenticatedFileIO;
import org.apache.amoro.io.writer.BaseTaskWriter;
import org.apache.amoro.io.writer.OutputFileFactory;
import org.apache.amoro.table.PrimaryKeySpec;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.io.FileAppenderFactory;

public abstract class ChangeTaskWriter<T>
extends BaseTaskWriter<T> {
    private long fileOffset = 0L;

    protected ChangeTaskWriter(FileFormat format, FileAppenderFactory<T> appenderFactory, OutputFileFactory outputFileFactory, AuthenticatedFileIO io, long targetFileSize, long mask, Schema schema, PartitionSpec spec, PrimaryKeySpec primaryKeySpec, boolean orderedWriter) {
        super(format, appenderFactory, outputFileFactory, io, targetFileSize, mask, schema, spec, primaryKeySpec, orderedWriter);
    }

    @Override
    protected BaseTaskWriter.DataWriterKey buildWriterKey(T row) {
        BaseTaskWriter.DataWriterKey key = super.buildWriterKey(row);
        ChangeAction action = this.action(row);
        switch (action) {
            case INSERT: 
            case UPDATE_AFTER: {
                return new BaseTaskWriter.DataWriterKey(key.getPartitionKey(), key.getTreeNode(), DataFileType.INSERT_FILE);
            }
            case DELETE: 
            case UPDATE_BEFORE: {
                return new BaseTaskWriter.DataWriterKey(key.getPartitionKey(), key.getTreeNode(), DataFileType.EQ_DELETE_FILE);
            }
        }
        throw new IllegalArgumentException("Unknown action:" + action.name());
    }

    @Override
    protected void write(BaseTaskWriter.TaskDataWriter<T> writer, T row) throws IOException {
        super.write(writer, this.appendFileOffset(row));
    }

    private T appendFileOffset(T row) {
        ChangeAction action = this.action(row);
        switch (action) {
            case INSERT: 
            case DELETE: 
            case UPDATE_BEFORE: {
                return this.appendMetaColumns(row, ++this.fileOffset);
            }
            case UPDATE_AFTER: {
                return this.appendMetaColumns(row, this.fileOffset);
            }
        }
        throw new IllegalArgumentException("Unknown action:" + action.name());
    }

    protected abstract T appendMetaColumns(T var1, Long var2);

    protected abstract ChangeAction action(T var1);
}

