/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.org.apache.zookeeper.server.persistence;

import org.apache.kyuubi.shade.org.apache.zookeeper.server.persistence.TxnLogToolkit;

class TxnLogToolkitCliParser {
    private String txnLogFileName;
    private boolean recoveryMode;
    private boolean verbose;
    private boolean force;

    TxnLogToolkitCliParser() {
    }

    String getTxnLogFileName() {
        return this.txnLogFileName;
    }

    boolean isRecoveryMode() {
        return this.recoveryMode;
    }

    boolean isVerbose() {
        return this.verbose;
    }

    boolean isForce() {
        return this.force;
    }

    void parse(String[] args) throws TxnLogToolkit.TxnLogToolkitParseException {
        if (args == null) {
            throw new TxnLogToolkit.TxnLogToolkitParseException(1, "No arguments given", new Object[0]);
        }
        this.txnLogFileName = null;
        for (String arg : args) {
            String par;
            if (arg.startsWith("--")) {
                par = arg.substring(2);
                if ("help".equalsIgnoreCase(par)) {
                    TxnLogToolkitCliParser.printHelpAndExit(0);
                    continue;
                }
                if ("recover".equalsIgnoreCase(par)) {
                    this.recoveryMode = true;
                    continue;
                }
                if ("verbose".equalsIgnoreCase(par)) {
                    this.verbose = true;
                    continue;
                }
                if ("dump".equalsIgnoreCase(par)) {
                    this.recoveryMode = false;
                    continue;
                }
                if ("yes".equalsIgnoreCase(par)) {
                    this.force = true;
                    continue;
                }
                throw new TxnLogToolkit.TxnLogToolkitParseException(1, "Invalid argument: %s", par);
            }
            if (arg.startsWith("-")) {
                par = arg.substring(1);
                if ("h".equalsIgnoreCase(par)) {
                    TxnLogToolkitCliParser.printHelpAndExit(0);
                    continue;
                }
                if ("r".equalsIgnoreCase(par)) {
                    this.recoveryMode = true;
                    continue;
                }
                if ("v".equalsIgnoreCase(par)) {
                    this.verbose = true;
                    continue;
                }
                if ("d".equalsIgnoreCase(par)) {
                    this.recoveryMode = false;
                    continue;
                }
                if ("y".equalsIgnoreCase(par)) {
                    this.force = true;
                    continue;
                }
                throw new TxnLogToolkit.TxnLogToolkitParseException(1, "Invalid argument: %s", par);
            }
            if (this.txnLogFileName != null) {
                throw new TxnLogToolkit.TxnLogToolkitParseException(1, "Invalid arguments: more than one TXN log file given", new Object[0]);
            }
            this.txnLogFileName = arg;
        }
        if (this.txnLogFileName == null) {
            throw new TxnLogToolkit.TxnLogToolkitParseException(1, "Invalid arguments: TXN log file name missing", new Object[0]);
        }
    }

    static void printHelpAndExit(int exitCode) {
        System.out.println("usage: TxnLogToolkit [-dhrvy] txn_log_file_name\n");
        System.out.println("    -d,--dump      Dump mode. Dump all entries of the log file. (this is the default)");
        System.out.println("    -h,--help      Print help message");
        System.out.println("    -r,--recover   Recovery mode. Re-calculate CRC for broken entries.");
        System.out.println("    -v,--verbose   Be verbose in recovery mode: print all entries, not just fixed ones.");
        System.out.println("    -y,--yes       Non-interactive mode: repair all CRC errors without asking");
        System.exit(exitCode);
    }
}

