/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.procedures;

import org.apache.iceberg.Snapshot;
import org.apache.iceberg.spark.procedures.BaseProcedure;
import org.apache.iceberg.spark.procedures.SparkProcedures;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.connector.iceberg.catalog.ProcedureParameter;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

class CherrypickSnapshotProcedure
extends BaseProcedure {
    private static final ProcedureParameter[] PARAMETERS = new ProcedureParameter[]{ProcedureParameter.required("table", DataTypes.StringType), ProcedureParameter.required("snapshot_id", DataTypes.LongType)};
    private static final StructType OUTPUT_TYPE = new StructType(new StructField[]{new StructField("source_snapshot_id", DataTypes.LongType, false, Metadata.empty()), new StructField("current_snapshot_id", DataTypes.LongType, false, Metadata.empty())});

    public static SparkProcedures.ProcedureBuilder builder() {
        return new BaseProcedure.Builder<CherrypickSnapshotProcedure>(){

            @Override
            protected CherrypickSnapshotProcedure doBuild() {
                return new CherrypickSnapshotProcedure(this.tableCatalog());
            }
        };
    }

    private CherrypickSnapshotProcedure(TableCatalog catalog) {
        super(catalog);
    }

    @Override
    public ProcedureParameter[] parameters() {
        return PARAMETERS;
    }

    @Override
    public StructType outputType() {
        return OUTPUT_TYPE;
    }

    @Override
    public InternalRow[] call(InternalRow args) {
        Identifier tableIdent = this.toIdentifier(args.getString(0), PARAMETERS[0].name());
        long snapshotId = args.getLong(1);
        return this.modifyIcebergTable(tableIdent, table -> {
            table.manageSnapshots().cherrypick(snapshotId).commit();
            Snapshot currentSnapshot = table.currentSnapshot();
            InternalRow outputRow = this.newInternalRow(snapshotId, currentSnapshot.snapshotId());
            return new InternalRow[]{outputRow};
        });
    }

    @Override
    public String description() {
        return "CherrypickSnapshotProcedure";
    }
}

