/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.data.vectorized;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.arrow.vector.NullCheckingForGet;
import org.apache.iceberg.Schema;
import org.apache.iceberg.arrow.vectorized.VectorizedReaderBuilder;
import org.apache.iceberg.data.DeleteFilter;
import org.apache.iceberg.parquet.TypeWithSchemaVisitor;
import org.apache.iceberg.parquet.VectorizedReader;
import org.apache.iceberg.spark.data.vectorized.ColumnarBatchReader;
import org.apache.iceberg.types.Type;
import org.apache.parquet.schema.MessageType;
import org.apache.spark.sql.catalyst.InternalRow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectorizedSparkParquetReaders {
    private static final Logger LOG = LoggerFactory.getLogger(VectorizedSparkParquetReaders.class);
    private static final String ENABLE_UNSAFE_MEMORY_ACCESS = "arrow.enable_unsafe_memory_access";
    private static final String ENABLE_UNSAFE_MEMORY_ACCESS_ENV = "ARROW_ENABLE_UNSAFE_MEMORY_ACCESS";
    private static final String ENABLE_NULL_CHECK_FOR_GET = "arrow.enable_null_check_for_get";
    private static final String ENABLE_NULL_CHECK_FOR_GET_ENV = "ARROW_ENABLE_NULL_CHECK_FOR_GET";

    private VectorizedSparkParquetReaders() {
    }

    public static ColumnarBatchReader buildReader(Schema expectedSchema, MessageType fileSchema, Map<Integer, ?> idToConstant, DeleteFilter<InternalRow> deleteFilter) {
        return (ColumnarBatchReader)((Object)TypeWithSchemaVisitor.visit((Type)expectedSchema.asStruct(), (org.apache.parquet.schema.Type)fileSchema, (TypeWithSchemaVisitor)new ReaderBuilder(expectedSchema, fileSchema, NullCheckingForGet.NULL_CHECKING_ENABLED, idToConstant, ColumnarBatchReader::new, deleteFilter)));
    }

    private static void enableUnsafeMemoryAccess() {
        String value = VectorizedSparkParquetReaders.confValue(ENABLE_UNSAFE_MEMORY_ACCESS, ENABLE_UNSAFE_MEMORY_ACCESS_ENV);
        if (value == null) {
            LOG.info("Enabling {}", (Object)ENABLE_UNSAFE_MEMORY_ACCESS);
            System.setProperty(ENABLE_UNSAFE_MEMORY_ACCESS, "true");
        } else {
            LOG.info("Unsafe memory access was configured explicitly: {}", (Object)value);
        }
    }

    private static void disableNullCheckForGet() {
        String value = VectorizedSparkParquetReaders.confValue(ENABLE_NULL_CHECK_FOR_GET, ENABLE_NULL_CHECK_FOR_GET_ENV);
        if (value == null) {
            LOG.info("Disabling {}", (Object)ENABLE_NULL_CHECK_FOR_GET);
            System.setProperty(ENABLE_NULL_CHECK_FOR_GET, "false");
        } else {
            LOG.info("Null checking for get calls was configured explicitly: {}", (Object)value);
        }
    }

    private static String confValue(String propName, String envName) {
        String propValue = System.getProperty(propName);
        if (propValue != null) {
            return propValue;
        }
        return System.getenv(envName);
    }

    static {
        try {
            VectorizedSparkParquetReaders.enableUnsafeMemoryAccess();
            VectorizedSparkParquetReaders.disableNullCheckForGet();
        }
        catch (Exception e) {
            LOG.warn("Couldn't set Arrow properties, which may impact read performance", (Throwable)e);
        }
    }

    private static class ReaderBuilder
    extends VectorizedReaderBuilder {
        private final DeleteFilter<InternalRow> deleteFilter;

        ReaderBuilder(Schema expectedSchema, MessageType parquetSchema, boolean setArrowValidityVector, Map<Integer, ?> idToConstant, Function<List<VectorizedReader<?>>, VectorizedReader<?>> readerFactory, DeleteFilter<InternalRow> deleteFilter) {
            super(expectedSchema, parquetSchema, setArrowValidityVector, idToConstant, readerFactory);
            this.deleteFilter = deleteFilter;
        }

        protected VectorizedReader<?> vectorizedReader(List<VectorizedReader<?>> reorderedFields) {
            VectorizedReader reader = super.vectorizedReader(reorderedFields);
            if (this.deleteFilter != null) {
                ((ColumnarBatchReader)reader).setDeleteFilter(this.deleteFilter);
            }
            return reader;
        }
    }
}

