/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.data;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.apache.avro.io.Decoder;
import org.apache.avro.util.Utf8;
import org.apache.iceberg.avro.ValueReader;
import org.apache.iceberg.avro.ValueReaders;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.UUIDUtil;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapData;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.unsafe.types.UTF8String;

public class SparkValueReaders {
    private SparkValueReaders() {
    }

    static ValueReader<UTF8String> strings() {
        return StringReader.INSTANCE;
    }

    static ValueReader<UTF8String> enums(List<String> symbols) {
        return new EnumReader(symbols);
    }

    static ValueReader<UTF8String> uuids() {
        return UUIDReader.INSTANCE;
    }

    static ValueReader<Decimal> decimal(ValueReader<byte[]> unscaledReader, int scale) {
        return new DecimalReader(unscaledReader, scale);
    }

    static ValueReader<ArrayData> array(ValueReader<?> elementReader) {
        return new ArrayReader(elementReader);
    }

    static ValueReader<ArrayBasedMapData> arrayMap(ValueReader<?> keyReader, ValueReader<?> valueReader) {
        return new ArrayMapReader(keyReader, valueReader);
    }

    static ValueReader<ArrayBasedMapData> map(ValueReader<?> keyReader, ValueReader<?> valueReader) {
        return new MapReader(keyReader, valueReader);
    }

    static ValueReader<InternalRow> struct(List<ValueReader<?>> readers, Types.StructType struct, Map<Integer, ?> idToConstant) {
        return new StructReader(readers, struct, idToConstant);
    }

    static class StructReader
    extends ValueReaders.StructReader<InternalRow> {
        private final int numFields;

        protected StructReader(List<ValueReader<?>> readers, Types.StructType struct, Map<Integer, ?> idToConstant) {
            super(readers, struct, idToConstant);
            this.numFields = readers.size();
        }

        protected InternalRow reuseOrCreate(Object reuse) {
            if (reuse instanceof GenericInternalRow && ((GenericInternalRow)reuse).numFields() == this.numFields) {
                return (InternalRow)reuse;
            }
            return new GenericInternalRow(this.numFields);
        }

        protected Object get(InternalRow struct, int pos) {
            return null;
        }

        protected void set(InternalRow struct, int pos, Object value) {
            if (value != null) {
                struct.update(pos, value);
            } else {
                struct.setNullAt(pos);
            }
        }
    }

    private static class MapReader
    implements ValueReader<ArrayBasedMapData> {
        private final ValueReader<?> keyReader;
        private final ValueReader<?> valueReader;
        private final List<Object> reusedKeyList = Lists.newArrayList();
        private final List<Object> reusedValueList = Lists.newArrayList();

        private MapReader(ValueReader<?> keyReader, ValueReader<?> valueReader) {
            this.keyReader = keyReader;
            this.valueReader = valueReader;
        }

        public ArrayBasedMapData read(Decoder decoder, Object reuse) throws IOException {
            this.reusedKeyList.clear();
            this.reusedValueList.clear();
            long chunkLength = decoder.readMapStart();
            while (chunkLength > 0L) {
                int i = 0;
                while ((long)i < chunkLength) {
                    this.reusedKeyList.add(this.keyReader.read(decoder, null));
                    this.reusedValueList.add(this.valueReader.read(decoder, null));
                    ++i;
                }
                chunkLength = decoder.mapNext();
            }
            return new ArrayBasedMapData((ArrayData)new GenericArrayData(this.reusedKeyList.toArray()), (ArrayData)new GenericArrayData(this.reusedValueList.toArray()));
        }
    }

    private static class ArrayMapReader
    implements ValueReader<ArrayBasedMapData> {
        private final ValueReader<?> keyReader;
        private final ValueReader<?> valueReader;
        private final List<Object> reusedKeyList = Lists.newArrayList();
        private final List<Object> reusedValueList = Lists.newArrayList();

        private ArrayMapReader(ValueReader<?> keyReader, ValueReader<?> valueReader) {
            this.keyReader = keyReader;
            this.valueReader = valueReader;
        }

        public ArrayBasedMapData read(Decoder decoder, Object reuse) throws IOException {
            this.reusedKeyList.clear();
            this.reusedValueList.clear();
            long chunkLength = decoder.readArrayStart();
            while (chunkLength > 0L) {
                int i = 0;
                while ((long)i < chunkLength) {
                    this.reusedKeyList.add(this.keyReader.read(decoder, null));
                    this.reusedValueList.add(this.valueReader.read(decoder, null));
                    ++i;
                }
                chunkLength = decoder.arrayNext();
            }
            return new ArrayBasedMapData((ArrayData)new GenericArrayData(this.reusedKeyList.toArray()), (ArrayData)new GenericArrayData(this.reusedValueList.toArray()));
        }
    }

    private static class ArrayReader
    implements ValueReader<ArrayData> {
        private final ValueReader<?> elementReader;
        private final List<Object> reusedList = Lists.newArrayList();

        private ArrayReader(ValueReader<?> elementReader) {
            this.elementReader = elementReader;
        }

        public GenericArrayData read(Decoder decoder, Object reuse) throws IOException {
            this.reusedList.clear();
            long chunkLength = decoder.readArrayStart();
            while (chunkLength > 0L) {
                int i = 0;
                while ((long)i < chunkLength) {
                    this.reusedList.add(this.elementReader.read(decoder, null));
                    ++i;
                }
                chunkLength = decoder.arrayNext();
            }
            return new GenericArrayData(this.reusedList.toArray());
        }
    }

    private static class DecimalReader
    implements ValueReader<Decimal> {
        private final ValueReader<byte[]> bytesReader;
        private final int scale;

        private DecimalReader(ValueReader<byte[]> bytesReader, int scale) {
            this.bytesReader = bytesReader;
            this.scale = scale;
        }

        public Decimal read(Decoder decoder, Object reuse) throws IOException {
            byte[] bytes = (byte[])this.bytesReader.read(decoder, null);
            return Decimal.apply((BigDecimal)new BigDecimal(new BigInteger(bytes), this.scale));
        }
    }

    private static class UUIDReader
    implements ValueReader<UTF8String> {
        private static final ThreadLocal<ByteBuffer> BUFFER = ThreadLocal.withInitial(() -> {
            ByteBuffer buffer = ByteBuffer.allocate(16);
            buffer.order(ByteOrder.BIG_ENDIAN);
            return buffer;
        });
        private static final UUIDReader INSTANCE = new UUIDReader();

        private UUIDReader() {
        }

        public UTF8String read(Decoder decoder, Object reuse) throws IOException {
            ByteBuffer buffer = BUFFER.get();
            buffer.rewind();
            decoder.readFixed(buffer.array(), 0, 16);
            return UTF8String.fromString((String)UUIDUtil.convert((ByteBuffer)buffer).toString());
        }
    }

    private static class EnumReader
    implements ValueReader<UTF8String> {
        private final UTF8String[] symbols;

        private EnumReader(List<String> symbols) {
            this.symbols = new UTF8String[symbols.size()];
            for (int i = 0; i < this.symbols.length; ++i) {
                this.symbols[i] = UTF8String.fromBytes((byte[])symbols.get(i).getBytes(StandardCharsets.UTF_8));
            }
        }

        public UTF8String read(Decoder decoder, Object ignore) throws IOException {
            int index = decoder.readEnum();
            return this.symbols[index];
        }
    }

    private static class StringReader
    implements ValueReader<UTF8String> {
        private static final StringReader INSTANCE = new StringReader();

        private StringReader() {
        }

        public UTF8String read(Decoder decoder, Object reuse) throws IOException {
            Utf8 utf8 = null;
            if (reuse instanceof UTF8String) {
                utf8 = new Utf8(((UTF8String)reuse).getBytes());
            }
            Utf8 string = decoder.readString(utf8);
            return UTF8String.fromBytes((byte[])string.getBytes(), (int)0, (int)string.getByteLength());
        }
    }
}

