/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.data;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.orc.OrcValueReader;
import org.apache.iceberg.orc.OrcValueReaders;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.UUIDUtil;
import org.apache.orc.storage.ql.exec.vector.BytesColumnVector;
import org.apache.orc.storage.ql.exec.vector.ColumnVector;
import org.apache.orc.storage.ql.exec.vector.DecimalColumnVector;
import org.apache.orc.storage.ql.exec.vector.ListColumnVector;
import org.apache.orc.storage.ql.exec.vector.MapColumnVector;
import org.apache.orc.storage.ql.exec.vector.TimestampColumnVector;
import org.apache.orc.storage.serde2.io.HiveDecimalWritable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapData;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.unsafe.types.UTF8String;

public class SparkOrcValueReaders {
    private SparkOrcValueReaders() {
    }

    public static OrcValueReader<UTF8String> utf8String() {
        return StringReader.INSTANCE;
    }

    public static OrcValueReader<UTF8String> uuids() {
        return UUIDReader.INSTANCE;
    }

    public static OrcValueReader<Long> timestampTzs() {
        return TimestampTzReader.INSTANCE;
    }

    public static OrcValueReader<Decimal> decimals(int precision, int scale) {
        if (precision <= Decimal.MAX_LONG_DIGITS()) {
            return new Decimal18Reader(precision, scale);
        }
        if (precision <= 38) {
            return new Decimal38Reader(precision, scale);
        }
        throw new IllegalArgumentException("Invalid precision: " + precision);
    }

    static OrcValueReader<?> struct(List<OrcValueReader<?>> readers, Types.StructType struct, Map<Integer, ?> idToConstant) {
        return new StructReader(readers, struct, idToConstant);
    }

    static OrcValueReader<?> array(OrcValueReader<?> elementReader) {
        return new ArrayReader(elementReader);
    }

    static OrcValueReader<?> map(OrcValueReader<?> keyReader, OrcValueReader<?> valueReader) {
        return new MapReader(keyReader, valueReader);
    }

    private static class Decimal38Reader
    implements OrcValueReader<Decimal> {
        private final int precision;
        private final int scale;

        Decimal38Reader(int precision, int scale) {
            this.precision = precision;
            this.scale = scale;
        }

        public Decimal nonNullRead(ColumnVector vector, int row) {
            BigDecimal value = ((DecimalColumnVector)vector).vector[row].getHiveDecimal().bigDecimalValue();
            Preconditions.checkArgument((value.precision() <= this.precision ? 1 : 0) != 0, (String)"Cannot read value as decimal(%s,%s), too large: %s", (Object)this.precision, (Object)this.scale, (Object)value);
            return new Decimal().set(new scala.math.BigDecimal(value), this.precision, this.scale);
        }
    }

    private static class Decimal18Reader
    implements OrcValueReader<Decimal> {
        private final int precision;
        private final int scale;

        Decimal18Reader(int precision, int scale) {
            this.precision = precision;
            this.scale = scale;
        }

        public Decimal nonNullRead(ColumnVector vector, int row) {
            HiveDecimalWritable value = ((DecimalColumnVector)vector).vector[row];
            Preconditions.checkArgument((value.precision() <= this.precision ? 1 : 0) != 0, (String)"Cannot read value as decimal(%s,%s), too large: %s", (Object)this.precision, (Object)this.scale, (Object)value);
            return new Decimal().set(value.serialize64(this.scale), this.precision, this.scale);
        }
    }

    private static class TimestampTzReader
    implements OrcValueReader<Long> {
        private static final TimestampTzReader INSTANCE = new TimestampTzReader();

        private TimestampTzReader() {
        }

        public Long nonNullRead(ColumnVector vector, int row) {
            TimestampColumnVector tcv = (TimestampColumnVector)vector;
            return Math.floorDiv(tcv.time[row], 1000L) * 1000000L + (long)Math.floorDiv(tcv.nanos[row], 1000);
        }
    }

    private static class UUIDReader
    implements OrcValueReader<UTF8String> {
        private static final UUIDReader INSTANCE = new UUIDReader();

        private UUIDReader() {
        }

        public UTF8String nonNullRead(ColumnVector vector, int row) {
            BytesColumnVector bytesVector = (BytesColumnVector)vector;
            ByteBuffer buffer = ByteBuffer.wrap(bytesVector.vector[row], bytesVector.start[row], bytesVector.length[row]);
            return UTF8String.fromString((String)UUIDUtil.convert((ByteBuffer)buffer).toString());
        }
    }

    private static class StringReader
    implements OrcValueReader<UTF8String> {
        private static final StringReader INSTANCE = new StringReader();

        private StringReader() {
        }

        public UTF8String nonNullRead(ColumnVector vector, int row) {
            BytesColumnVector bytesVector = (BytesColumnVector)vector;
            return UTF8String.fromBytes((byte[])bytesVector.vector[row], (int)bytesVector.start[row], (int)bytesVector.length[row]);
        }
    }

    static class StructReader
    extends OrcValueReaders.StructReader<InternalRow> {
        private final int numFields;

        protected StructReader(List<OrcValueReader<?>> readers, Types.StructType struct, Map<Integer, ?> idToConstant) {
            super(readers, struct, idToConstant);
            this.numFields = struct.fields().size();
        }

        protected InternalRow create() {
            return new GenericInternalRow(this.numFields);
        }

        protected void set(InternalRow struct, int pos, Object value) {
            if (value != null) {
                struct.update(pos, value);
            } else {
                struct.setNullAt(pos);
            }
        }
    }

    private static class MapReader
    implements OrcValueReader<MapData> {
        private final OrcValueReader<?> keyReader;
        private final OrcValueReader<?> valueReader;

        private MapReader(OrcValueReader<?> keyReader, OrcValueReader<?> valueReader) {
            this.keyReader = keyReader;
            this.valueReader = valueReader;
        }

        public MapData nonNullRead(ColumnVector vector, int row) {
            MapColumnVector mapVector = (MapColumnVector)vector;
            int offset = (int)mapVector.offsets[row];
            long length = mapVector.lengths[row];
            ArrayList keys = Lists.newArrayListWithExpectedSize((int)((int)length));
            ArrayList values = Lists.newArrayListWithExpectedSize((int)((int)length));
            int c = 0;
            while ((long)c < length) {
                keys.add(this.keyReader.read(mapVector.keys, offset + c));
                values.add(this.valueReader.read(mapVector.values, offset + c));
                ++c;
            }
            return new ArrayBasedMapData((ArrayData)new GenericArrayData(keys.toArray()), (ArrayData)new GenericArrayData(values.toArray()));
        }

        public void setBatchContext(long batchOffsetInFile) {
            this.keyReader.setBatchContext(batchOffsetInFile);
            this.valueReader.setBatchContext(batchOffsetInFile);
        }
    }

    private static class ArrayReader
    implements OrcValueReader<ArrayData> {
        private final OrcValueReader<?> elementReader;

        private ArrayReader(OrcValueReader<?> elementReader) {
            this.elementReader = elementReader;
        }

        public ArrayData nonNullRead(ColumnVector vector, int row) {
            ListColumnVector listVector = (ListColumnVector)vector;
            int offset = (int)listVector.offsets[row];
            int length = (int)listVector.lengths[row];
            ArrayList elements = Lists.newArrayListWithExpectedSize((int)length);
            for (int c = 0; c < length; ++c) {
                elements.add(this.elementReader.read(listVector.child, offset + c));
            }
            return new GenericArrayData(elements.toArray());
        }

        public void setBatchContext(long batchOffsetInFile) {
            this.elementReader.setBatchContext(batchOffsetInFile);
        }
    }
}

