/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.iceberg.ExpireSnapshots;
import org.apache.iceberg.HasTableOperations;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.actions.ExpireSnapshots;
import org.apache.iceberg.actions.ImmutableExpireSnapshots;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.SupportsBulkOperations;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.spark.JobGroupInfo;
import org.apache.iceberg.spark.actions.BaseSparkAction;
import org.apache.iceberg.spark.actions.FileInfo;
import org.apache.iceberg.util.PropertyUtil;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpireSnapshotsSparkAction
extends BaseSparkAction<ExpireSnapshotsSparkAction>
implements org.apache.iceberg.actions.ExpireSnapshots {
    public static final String STREAM_RESULTS = "stream-results";
    public static final boolean STREAM_RESULTS_DEFAULT = false;
    private static final Logger LOG = LoggerFactory.getLogger(ExpireSnapshotsSparkAction.class);
    private final Table table;
    private final TableOperations ops;
    private final Set<Long> expiredSnapshotIds = Sets.newHashSet();
    private Long expireOlderThanValue = null;
    private Integer retainLastValue = null;
    private Consumer<String> deleteFunc = null;
    private ExecutorService deleteExecutorService = null;
    private Dataset<FileInfo> expiredFileDS = null;

    ExpireSnapshotsSparkAction(SparkSession spark, Table table) {
        super(spark);
        this.table = table;
        this.ops = ((HasTableOperations)table).operations();
        ValidationException.check((boolean)PropertyUtil.propertyAsBoolean((Map)table.properties(), (String)"gc.enabled", (boolean)true), (String)"Cannot expire snapshots: GC is disabled (deleting files may corrupt other tables)", (Object[])new Object[0]);
    }

    @Override
    protected ExpireSnapshotsSparkAction self() {
        return this;
    }

    public ExpireSnapshotsSparkAction executeDeleteWith(ExecutorService executorService) {
        this.deleteExecutorService = executorService;
        return this;
    }

    public ExpireSnapshotsSparkAction expireSnapshotId(long snapshotId) {
        this.expiredSnapshotIds.add(snapshotId);
        return this;
    }

    public ExpireSnapshotsSparkAction expireOlderThan(long timestampMillis) {
        this.expireOlderThanValue = timestampMillis;
        return this;
    }

    public ExpireSnapshotsSparkAction retainLast(int numSnapshots) {
        Preconditions.checkArgument((1 <= numSnapshots ? 1 : 0) != 0, (String)"Number of snapshots to retain must be at least 1, cannot be: %s", (int)numSnapshots);
        this.retainLastValue = numSnapshots;
        return this;
    }

    public ExpireSnapshotsSparkAction deleteWith(Consumer<String> newDeleteFunc) {
        this.deleteFunc = newDeleteFunc;
        return this;
    }

    public Dataset<FileInfo> expireFiles() {
        if (this.expiredFileDS == null) {
            TableMetadata originalMetadata = this.ops.current();
            ExpireSnapshots expireSnapshots = this.table.expireSnapshots();
            for (long id : this.expiredSnapshotIds) {
                expireSnapshots = expireSnapshots.expireSnapshotId(id);
            }
            if (this.expireOlderThanValue != null) {
                expireSnapshots = expireSnapshots.expireOlderThan(this.expireOlderThanValue.longValue());
            }
            if (this.retainLastValue != null) {
                expireSnapshots = expireSnapshots.retainLast(this.retainLastValue.intValue());
            }
            expireSnapshots.cleanExpiredFiles(false).commit();
            TableMetadata updatedMetadata = this.ops.refresh();
            Dataset<FileInfo> validFileDS = this.fileDS(updatedMetadata);
            Set<Long> deletedSnapshotIds = this.findExpiredSnapshotIds(originalMetadata, updatedMetadata);
            Dataset<FileInfo> deleteCandidateFileDS = this.fileDS(originalMetadata, deletedSnapshotIds);
            this.expiredFileDS = deleteCandidateFileDS.except(validFileDS);
        }
        return this.expiredFileDS;
    }

    public ExpireSnapshots.Result execute() {
        JobGroupInfo info = this.newJobGroupInfo("EXPIRE-SNAPSHOTS", this.jobDesc());
        return this.withJobGroupInfo(info, this::doExecute);
    }

    private String jobDesc() {
        ArrayList options = Lists.newArrayList();
        if (this.expireOlderThanValue != null) {
            options.add("older_than=" + this.expireOlderThanValue);
        }
        if (this.retainLastValue != null) {
            options.add("retain_last=" + this.retainLastValue);
        }
        if (!this.expiredSnapshotIds.isEmpty()) {
            Long first = (Long)this.expiredSnapshotIds.stream().findFirst().get();
            if (this.expiredSnapshotIds.size() > 1) {
                options.add(String.format("snapshot_ids: %s (%s more...)", first, this.expiredSnapshotIds.size() - 1));
            } else {
                options.add(String.format("snapshot_id: %s", first));
            }
        }
        return String.format("Expiring snapshots (%s) in %s", COMMA_JOINER.join((Iterable)options), this.table.name());
    }

    private ExpireSnapshots.Result doExecute() {
        if (this.streamResults()) {
            return this.deleteFiles(this.expireFiles().toLocalIterator());
        }
        return this.deleteFiles(this.expireFiles().collectAsList().iterator());
    }

    private boolean streamResults() {
        return PropertyUtil.propertyAsBoolean(this.options(), (String)STREAM_RESULTS, (boolean)false);
    }

    private Dataset<FileInfo> fileDS(TableMetadata metadata) {
        return this.fileDS(metadata, null);
    }

    private Dataset<FileInfo> fileDS(TableMetadata metadata, Set<Long> snapshotIds) {
        Table staticTable = this.newStaticTable(metadata, this.table.io());
        return this.contentFileDS(staticTable, snapshotIds).union(this.manifestDS(staticTable, snapshotIds)).union(this.manifestListDS(staticTable, snapshotIds)).union(this.statisticsFileDS(staticTable, snapshotIds));
    }

    private Set<Long> findExpiredSnapshotIds(TableMetadata originalMetadata, TableMetadata updatedMetadata) {
        Set retainedSnapshots = updatedMetadata.snapshots().stream().map(Snapshot::snapshotId).collect(Collectors.toSet());
        return originalMetadata.snapshots().stream().map(Snapshot::snapshotId).filter(id -> !retainedSnapshots.contains(id)).collect(Collectors.toSet());
    }

    private ExpireSnapshots.Result deleteFiles(Iterator<FileInfo> files) {
        BaseSparkAction.DeleteSummary summary;
        if (this.deleteFunc == null && this.table.io() instanceof SupportsBulkOperations) {
            summary = this.deleteFiles((SupportsBulkOperations)this.table.io(), files);
        } else if (this.deleteFunc == null) {
            LOG.info("Table IO {} does not support bulk operations. Using non-bulk deletes.", (Object)this.table.io().getClass().getName());
            summary = this.deleteFiles(this.deleteExecutorService, arg_0 -> ((FileIO)this.table.io()).deleteFile(arg_0), files);
        } else {
            LOG.info("Custom delete function provided. Using non-bulk deletes");
            summary = this.deleteFiles(this.deleteExecutorService, this.deleteFunc, files);
        }
        LOG.info("Deleted {} total files", (Object)summary.totalFilesCount());
        return ImmutableExpireSnapshots.Result.builder().deletedDataFilesCount(summary.dataFilesCount()).deletedPositionDeleteFilesCount(summary.positionDeleteFilesCount()).deletedEqualityDeleteFilesCount(summary.equalityDeleteFilesCount()).deletedManifestsCount(summary.manifestsCount()).deletedManifestListsCount(summary.manifestListsCount()).deletedStatisticsFilesCount(summary.statisticsFilesCount()).build();
    }
}

