/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TransformType {
    FIND_MATCHES("FIND_MATCHES"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TransformType> VALUE_MAP;
    private final String value;

    private TransformType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TransformType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TransformType> knownValues() {
        EnumSet<TransformType> knownValues = EnumSet.allOf(TransformType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TransformType.class, TransformType::toString);
    }
}

