/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.glue.model.EnclosedInStringPropertiesCopier;
import software.amazon.awssdk.services.glue.model.GlueRecordType;
import software.amazon.awssdk.services.glue.model.JDBCDataType;
import software.amazon.awssdk.services.glue.model.JDBCDataTypeMappingCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JDBCConnectorOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JDBCConnectorOptions> {
    private static final SdkField<String> FILTER_PREDICATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FilterPredicate").getter(JDBCConnectorOptions.getter(JDBCConnectorOptions::filterPredicate)).setter(JDBCConnectorOptions.setter(Builder::filterPredicate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterPredicate").build()}).build();
    private static final SdkField<String> PARTITION_COLUMN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PartitionColumn").getter(JDBCConnectorOptions.getter(JDBCConnectorOptions::partitionColumn)).setter(JDBCConnectorOptions.setter(Builder::partitionColumn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartitionColumn").build()}).build();
    private static final SdkField<Long> LOWER_BOUND_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("LowerBound").getter(JDBCConnectorOptions.getter(JDBCConnectorOptions::lowerBound)).setter(JDBCConnectorOptions.setter(Builder::lowerBound)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LowerBound").build()}).build();
    private static final SdkField<Long> UPPER_BOUND_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("UpperBound").getter(JDBCConnectorOptions.getter(JDBCConnectorOptions::upperBound)).setter(JDBCConnectorOptions.setter(Builder::upperBound)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpperBound").build()}).build();
    private static final SdkField<Long> NUM_PARTITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("NumPartitions").getter(JDBCConnectorOptions.getter(JDBCConnectorOptions::numPartitions)).setter(JDBCConnectorOptions.setter(Builder::numPartitions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumPartitions").build()}).build();
    private static final SdkField<List<String>> JOB_BOOKMARK_KEYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("JobBookmarkKeys").getter(JDBCConnectorOptions.getter(JDBCConnectorOptions::jobBookmarkKeys)).setter(JDBCConnectorOptions.setter(Builder::jobBookmarkKeys)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobBookmarkKeys").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> JOB_BOOKMARK_KEYS_SORT_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobBookmarkKeysSortOrder").getter(JDBCConnectorOptions.getter(JDBCConnectorOptions::jobBookmarkKeysSortOrder)).setter(JDBCConnectorOptions.setter(Builder::jobBookmarkKeysSortOrder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobBookmarkKeysSortOrder").build()}).build();
    private static final SdkField<Map<String, String>> DATA_TYPE_MAPPING_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("DataTypeMapping").getter(JDBCConnectorOptions.getter(JDBCConnectorOptions::dataTypeMappingAsStrings)).setter(JDBCConnectorOptions.setter(Builder::dataTypeMappingWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataTypeMapping").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_PREDICATE_FIELD, PARTITION_COLUMN_FIELD, LOWER_BOUND_FIELD, UPPER_BOUND_FIELD, NUM_PARTITIONS_FIELD, JOB_BOOKMARK_KEYS_FIELD, JOB_BOOKMARK_KEYS_SORT_ORDER_FIELD, DATA_TYPE_MAPPING_FIELD));
    private static final long serialVersionUID = 1L;
    private final String filterPredicate;
    private final String partitionColumn;
    private final Long lowerBound;
    private final Long upperBound;
    private final Long numPartitions;
    private final List<String> jobBookmarkKeys;
    private final String jobBookmarkKeysSortOrder;
    private final Map<String, String> dataTypeMapping;

    private JDBCConnectorOptions(BuilderImpl builder) {
        this.filterPredicate = builder.filterPredicate;
        this.partitionColumn = builder.partitionColumn;
        this.lowerBound = builder.lowerBound;
        this.upperBound = builder.upperBound;
        this.numPartitions = builder.numPartitions;
        this.jobBookmarkKeys = builder.jobBookmarkKeys;
        this.jobBookmarkKeysSortOrder = builder.jobBookmarkKeysSortOrder;
        this.dataTypeMapping = builder.dataTypeMapping;
    }

    public final String filterPredicate() {
        return this.filterPredicate;
    }

    public final String partitionColumn() {
        return this.partitionColumn;
    }

    public final Long lowerBound() {
        return this.lowerBound;
    }

    public final Long upperBound() {
        return this.upperBound;
    }

    public final Long numPartitions() {
        return this.numPartitions;
    }

    public final boolean hasJobBookmarkKeys() {
        return this.jobBookmarkKeys != null && !(this.jobBookmarkKeys instanceof SdkAutoConstructList);
    }

    public final List<String> jobBookmarkKeys() {
        return this.jobBookmarkKeys;
    }

    public final String jobBookmarkKeysSortOrder() {
        return this.jobBookmarkKeysSortOrder;
    }

    public final Map<JDBCDataType, GlueRecordType> dataTypeMapping() {
        return JDBCDataTypeMappingCopier.copyStringToEnum(this.dataTypeMapping);
    }

    public final boolean hasDataTypeMapping() {
        return this.dataTypeMapping != null && !(this.dataTypeMapping instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> dataTypeMappingAsStrings() {
        return this.dataTypeMapping;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.filterPredicate());
        hashCode = 31 * hashCode + Objects.hashCode(this.partitionColumn());
        hashCode = 31 * hashCode + Objects.hashCode(this.lowerBound());
        hashCode = 31 * hashCode + Objects.hashCode(this.upperBound());
        hashCode = 31 * hashCode + Objects.hashCode(this.numPartitions());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasJobBookmarkKeys() ? this.jobBookmarkKeys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.jobBookmarkKeysSortOrder());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDataTypeMapping() ? this.dataTypeMappingAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JDBCConnectorOptions)) {
            return false;
        }
        JDBCConnectorOptions other = (JDBCConnectorOptions)obj;
        return Objects.equals(this.filterPredicate(), other.filterPredicate()) && Objects.equals(this.partitionColumn(), other.partitionColumn()) && Objects.equals(this.lowerBound(), other.lowerBound()) && Objects.equals(this.upperBound(), other.upperBound()) && Objects.equals(this.numPartitions(), other.numPartitions()) && this.hasJobBookmarkKeys() == other.hasJobBookmarkKeys() && Objects.equals(this.jobBookmarkKeys(), other.jobBookmarkKeys()) && Objects.equals(this.jobBookmarkKeysSortOrder(), other.jobBookmarkKeysSortOrder()) && this.hasDataTypeMapping() == other.hasDataTypeMapping() && Objects.equals(this.dataTypeMappingAsStrings(), other.dataTypeMappingAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"JDBCConnectorOptions").add("FilterPredicate", (Object)this.filterPredicate()).add("PartitionColumn", (Object)this.partitionColumn()).add("LowerBound", (Object)this.lowerBound()).add("UpperBound", (Object)this.upperBound()).add("NumPartitions", (Object)this.numPartitions()).add("JobBookmarkKeys", this.hasJobBookmarkKeys() ? this.jobBookmarkKeys() : null).add("JobBookmarkKeysSortOrder", (Object)this.jobBookmarkKeysSortOrder()).add("DataTypeMapping", this.hasDataTypeMapping() ? this.dataTypeMappingAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FilterPredicate": {
                return Optional.ofNullable(clazz.cast(this.filterPredicate()));
            }
            case "PartitionColumn": {
                return Optional.ofNullable(clazz.cast(this.partitionColumn()));
            }
            case "LowerBound": {
                return Optional.ofNullable(clazz.cast(this.lowerBound()));
            }
            case "UpperBound": {
                return Optional.ofNullable(clazz.cast(this.upperBound()));
            }
            case "NumPartitions": {
                return Optional.ofNullable(clazz.cast(this.numPartitions()));
            }
            case "JobBookmarkKeys": {
                return Optional.ofNullable(clazz.cast(this.jobBookmarkKeys()));
            }
            case "JobBookmarkKeysSortOrder": {
                return Optional.ofNullable(clazz.cast(this.jobBookmarkKeysSortOrder()));
            }
            case "DataTypeMapping": {
                return Optional.ofNullable(clazz.cast(this.dataTypeMappingAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JDBCConnectorOptions, T> g) {
        return obj -> g.apply((JDBCConnectorOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String filterPredicate;
        private String partitionColumn;
        private Long lowerBound;
        private Long upperBound;
        private Long numPartitions;
        private List<String> jobBookmarkKeys = DefaultSdkAutoConstructList.getInstance();
        private String jobBookmarkKeysSortOrder;
        private Map<String, String> dataTypeMapping = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(JDBCConnectorOptions model) {
            this.filterPredicate(model.filterPredicate);
            this.partitionColumn(model.partitionColumn);
            this.lowerBound(model.lowerBound);
            this.upperBound(model.upperBound);
            this.numPartitions(model.numPartitions);
            this.jobBookmarkKeys(model.jobBookmarkKeys);
            this.jobBookmarkKeysSortOrder(model.jobBookmarkKeysSortOrder);
            this.dataTypeMappingWithStrings(model.dataTypeMapping);
        }

        public final String getFilterPredicate() {
            return this.filterPredicate;
        }

        public final void setFilterPredicate(String filterPredicate) {
            this.filterPredicate = filterPredicate;
        }

        @Override
        public final Builder filterPredicate(String filterPredicate) {
            this.filterPredicate = filterPredicate;
            return this;
        }

        public final String getPartitionColumn() {
            return this.partitionColumn;
        }

        public final void setPartitionColumn(String partitionColumn) {
            this.partitionColumn = partitionColumn;
        }

        @Override
        public final Builder partitionColumn(String partitionColumn) {
            this.partitionColumn = partitionColumn;
            return this;
        }

        public final Long getLowerBound() {
            return this.lowerBound;
        }

        public final void setLowerBound(Long lowerBound) {
            this.lowerBound = lowerBound;
        }

        @Override
        public final Builder lowerBound(Long lowerBound) {
            this.lowerBound = lowerBound;
            return this;
        }

        public final Long getUpperBound() {
            return this.upperBound;
        }

        public final void setUpperBound(Long upperBound) {
            this.upperBound = upperBound;
        }

        @Override
        public final Builder upperBound(Long upperBound) {
            this.upperBound = upperBound;
            return this;
        }

        public final Long getNumPartitions() {
            return this.numPartitions;
        }

        public final void setNumPartitions(Long numPartitions) {
            this.numPartitions = numPartitions;
        }

        @Override
        public final Builder numPartitions(Long numPartitions) {
            this.numPartitions = numPartitions;
            return this;
        }

        public final Collection<String> getJobBookmarkKeys() {
            if (this.jobBookmarkKeys instanceof SdkAutoConstructList) {
                return null;
            }
            return this.jobBookmarkKeys;
        }

        public final void setJobBookmarkKeys(Collection<String> jobBookmarkKeys) {
            this.jobBookmarkKeys = EnclosedInStringPropertiesCopier.copy(jobBookmarkKeys);
        }

        @Override
        public final Builder jobBookmarkKeys(Collection<String> jobBookmarkKeys) {
            this.jobBookmarkKeys = EnclosedInStringPropertiesCopier.copy(jobBookmarkKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobBookmarkKeys(String ... jobBookmarkKeys) {
            this.jobBookmarkKeys(Arrays.asList(jobBookmarkKeys));
            return this;
        }

        public final String getJobBookmarkKeysSortOrder() {
            return this.jobBookmarkKeysSortOrder;
        }

        public final void setJobBookmarkKeysSortOrder(String jobBookmarkKeysSortOrder) {
            this.jobBookmarkKeysSortOrder = jobBookmarkKeysSortOrder;
        }

        @Override
        public final Builder jobBookmarkKeysSortOrder(String jobBookmarkKeysSortOrder) {
            this.jobBookmarkKeysSortOrder = jobBookmarkKeysSortOrder;
            return this;
        }

        public final Map<String, String> getDataTypeMapping() {
            if (this.dataTypeMapping instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.dataTypeMapping;
        }

        public final void setDataTypeMapping(Map<String, String> dataTypeMapping) {
            this.dataTypeMapping = JDBCDataTypeMappingCopier.copy(dataTypeMapping);
        }

        @Override
        public final Builder dataTypeMappingWithStrings(Map<String, String> dataTypeMapping) {
            this.dataTypeMapping = JDBCDataTypeMappingCopier.copy(dataTypeMapping);
            return this;
        }

        @Override
        public final Builder dataTypeMapping(Map<JDBCDataType, GlueRecordType> dataTypeMapping) {
            this.dataTypeMapping = JDBCDataTypeMappingCopier.copyEnumToString(dataTypeMapping);
            return this;
        }

        public JDBCConnectorOptions build() {
            return new JDBCConnectorOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JDBCConnectorOptions> {
        public Builder filterPredicate(String var1);

        public Builder partitionColumn(String var1);

        public Builder lowerBound(Long var1);

        public Builder upperBound(Long var1);

        public Builder numPartitions(Long var1);

        public Builder jobBookmarkKeys(Collection<String> var1);

        public Builder jobBookmarkKeys(String ... var1);

        public Builder jobBookmarkKeysSortOrder(String var1);

        public Builder dataTypeMappingWithStrings(Map<String, String> var1);

        public Builder dataTypeMapping(Map<JDBCDataType, GlueRecordType> var1);
    }
}

