/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.PathListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HudiTarget
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HudiTarget> {
    private static final SdkField<List<String>> PATHS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Paths").getter(HudiTarget.getter(HudiTarget::paths)).setter(HudiTarget.setter(Builder::paths)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Paths").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CONNECTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectionName").getter(HudiTarget.getter(HudiTarget::connectionName)).setter(HudiTarget.setter(Builder::connectionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionName").build()}).build();
    private static final SdkField<List<String>> EXCLUSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Exclusions").getter(HudiTarget.getter(HudiTarget::exclusions)).setter(HudiTarget.setter(Builder::exclusions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Exclusions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAXIMUM_TRAVERSAL_DEPTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaximumTraversalDepth").getter(HudiTarget.getter(HudiTarget::maximumTraversalDepth)).setter(HudiTarget.setter(Builder::maximumTraversalDepth)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumTraversalDepth").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PATHS_FIELD, CONNECTION_NAME_FIELD, EXCLUSIONS_FIELD, MAXIMUM_TRAVERSAL_DEPTH_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> paths;
    private final String connectionName;
    private final List<String> exclusions;
    private final Integer maximumTraversalDepth;

    private HudiTarget(BuilderImpl builder) {
        this.paths = builder.paths;
        this.connectionName = builder.connectionName;
        this.exclusions = builder.exclusions;
        this.maximumTraversalDepth = builder.maximumTraversalDepth;
    }

    public final boolean hasPaths() {
        return this.paths != null && !(this.paths instanceof SdkAutoConstructList);
    }

    public final List<String> paths() {
        return this.paths;
    }

    public final String connectionName() {
        return this.connectionName;
    }

    public final boolean hasExclusions() {
        return this.exclusions != null && !(this.exclusions instanceof SdkAutoConstructList);
    }

    public final List<String> exclusions() {
        return this.exclusions;
    }

    public final Integer maximumTraversalDepth() {
        return this.maximumTraversalDepth;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPaths() ? this.paths() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExclusions() ? this.exclusions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumTraversalDepth());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HudiTarget)) {
            return false;
        }
        HudiTarget other = (HudiTarget)obj;
        return this.hasPaths() == other.hasPaths() && Objects.equals(this.paths(), other.paths()) && Objects.equals(this.connectionName(), other.connectionName()) && this.hasExclusions() == other.hasExclusions() && Objects.equals(this.exclusions(), other.exclusions()) && Objects.equals(this.maximumTraversalDepth(), other.maximumTraversalDepth());
    }

    public final String toString() {
        return ToString.builder((String)"HudiTarget").add("Paths", this.hasPaths() ? this.paths() : null).add("ConnectionName", (Object)this.connectionName()).add("Exclusions", this.hasExclusions() ? this.exclusions() : null).add("MaximumTraversalDepth", (Object)this.maximumTraversalDepth()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Paths": {
                return Optional.ofNullable(clazz.cast(this.paths()));
            }
            case "ConnectionName": {
                return Optional.ofNullable(clazz.cast(this.connectionName()));
            }
            case "Exclusions": {
                return Optional.ofNullable(clazz.cast(this.exclusions()));
            }
            case "MaximumTraversalDepth": {
                return Optional.ofNullable(clazz.cast(this.maximumTraversalDepth()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HudiTarget, T> g) {
        return obj -> g.apply((HudiTarget)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> paths = DefaultSdkAutoConstructList.getInstance();
        private String connectionName;
        private List<String> exclusions = DefaultSdkAutoConstructList.getInstance();
        private Integer maximumTraversalDepth;

        private BuilderImpl() {
        }

        private BuilderImpl(HudiTarget model) {
            this.paths(model.paths);
            this.connectionName(model.connectionName);
            this.exclusions(model.exclusions);
            this.maximumTraversalDepth(model.maximumTraversalDepth);
        }

        public final Collection<String> getPaths() {
            if (this.paths instanceof SdkAutoConstructList) {
                return null;
            }
            return this.paths;
        }

        public final void setPaths(Collection<String> paths) {
            this.paths = PathListCopier.copy(paths);
        }

        @Override
        public final Builder paths(Collection<String> paths) {
            this.paths = PathListCopier.copy(paths);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder paths(String ... paths) {
            this.paths(Arrays.asList(paths));
            return this;
        }

        public final String getConnectionName() {
            return this.connectionName;
        }

        public final void setConnectionName(String connectionName) {
            this.connectionName = connectionName;
        }

        @Override
        public final Builder connectionName(String connectionName) {
            this.connectionName = connectionName;
            return this;
        }

        public final Collection<String> getExclusions() {
            if (this.exclusions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.exclusions;
        }

        public final void setExclusions(Collection<String> exclusions) {
            this.exclusions = PathListCopier.copy(exclusions);
        }

        @Override
        public final Builder exclusions(Collection<String> exclusions) {
            this.exclusions = PathListCopier.copy(exclusions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exclusions(String ... exclusions) {
            this.exclusions(Arrays.asList(exclusions));
            return this;
        }

        public final Integer getMaximumTraversalDepth() {
            return this.maximumTraversalDepth;
        }

        public final void setMaximumTraversalDepth(Integer maximumTraversalDepth) {
            this.maximumTraversalDepth = maximumTraversalDepth;
        }

        @Override
        public final Builder maximumTraversalDepth(Integer maximumTraversalDepth) {
            this.maximumTraversalDepth = maximumTraversalDepth;
            return this;
        }

        public HudiTarget build() {
            return new HudiTarget(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HudiTarget> {
        public Builder paths(Collection<String> var1);

        public Builder paths(String ... var1);

        public Builder connectionName(String var1);

        public Builder exclusions(Collection<String> var1);

        public Builder exclusions(String ... var1);

        public Builder maximumTraversalDepth(Integer var1);
    }
}

