/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.GlueResponse;
import software.amazon.awssdk.services.glue.model.PartitionIndexDescriptor;
import software.amazon.awssdk.services.glue.model.PartitionIndexDescriptorListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetPartitionIndexesResponse
extends GlueResponse
implements ToCopyableBuilder<Builder, GetPartitionIndexesResponse> {
    private static final SdkField<List<PartitionIndexDescriptor>> PARTITION_INDEX_DESCRIPTOR_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PartitionIndexDescriptorList").getter(GetPartitionIndexesResponse.getter(GetPartitionIndexesResponse::partitionIndexDescriptorList)).setter(GetPartitionIndexesResponse.setter(Builder::partitionIndexDescriptorList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartitionIndexDescriptorList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PartitionIndexDescriptor::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetPartitionIndexesResponse.getter(GetPartitionIndexesResponse::nextToken)).setter(GetPartitionIndexesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARTITION_INDEX_DESCRIPTOR_LIST_FIELD, NEXT_TOKEN_FIELD));
    private final List<PartitionIndexDescriptor> partitionIndexDescriptorList;
    private final String nextToken;

    private GetPartitionIndexesResponse(BuilderImpl builder) {
        super(builder);
        this.partitionIndexDescriptorList = builder.partitionIndexDescriptorList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasPartitionIndexDescriptorList() {
        return this.partitionIndexDescriptorList != null && !(this.partitionIndexDescriptorList instanceof SdkAutoConstructList);
    }

    public final List<PartitionIndexDescriptor> partitionIndexDescriptorList() {
        return this.partitionIndexDescriptorList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPartitionIndexDescriptorList() ? this.partitionIndexDescriptorList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPartitionIndexesResponse)) {
            return false;
        }
        GetPartitionIndexesResponse other = (GetPartitionIndexesResponse)((Object)obj);
        return this.hasPartitionIndexDescriptorList() == other.hasPartitionIndexDescriptorList() && Objects.equals(this.partitionIndexDescriptorList(), other.partitionIndexDescriptorList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetPartitionIndexesResponse").add("PartitionIndexDescriptorList", this.hasPartitionIndexDescriptorList() ? this.partitionIndexDescriptorList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PartitionIndexDescriptorList": {
                return Optional.ofNullable(clazz.cast(this.partitionIndexDescriptorList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetPartitionIndexesResponse, T> g) {
        return obj -> g.apply((GetPartitionIndexesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueResponse.BuilderImpl
    implements Builder {
        private List<PartitionIndexDescriptor> partitionIndexDescriptorList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPartitionIndexesResponse model) {
            super(model);
            this.partitionIndexDescriptorList(model.partitionIndexDescriptorList);
            this.nextToken(model.nextToken);
        }

        public final List<PartitionIndexDescriptor.Builder> getPartitionIndexDescriptorList() {
            List<PartitionIndexDescriptor.Builder> result = PartitionIndexDescriptorListCopier.copyToBuilder(this.partitionIndexDescriptorList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPartitionIndexDescriptorList(Collection<PartitionIndexDescriptor.BuilderImpl> partitionIndexDescriptorList) {
            this.partitionIndexDescriptorList = PartitionIndexDescriptorListCopier.copyFromBuilder(partitionIndexDescriptorList);
        }

        @Override
        public final Builder partitionIndexDescriptorList(Collection<PartitionIndexDescriptor> partitionIndexDescriptorList) {
            this.partitionIndexDescriptorList = PartitionIndexDescriptorListCopier.copy(partitionIndexDescriptorList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partitionIndexDescriptorList(PartitionIndexDescriptor ... partitionIndexDescriptorList) {
            this.partitionIndexDescriptorList(Arrays.asList(partitionIndexDescriptorList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partitionIndexDescriptorList(Consumer<PartitionIndexDescriptor.Builder> ... partitionIndexDescriptorList) {
            this.partitionIndexDescriptorList(Stream.of(partitionIndexDescriptorList).map(c -> (PartitionIndexDescriptor)((PartitionIndexDescriptor.Builder)PartitionIndexDescriptor.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetPartitionIndexesResponse build() {
            return new GetPartitionIndexesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlueResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetPartitionIndexesResponse> {
        public Builder partitionIndexDescriptorList(Collection<PartitionIndexDescriptor> var1);

        public Builder partitionIndexDescriptorList(PartitionIndexDescriptor ... var1);

        public Builder partitionIndexDescriptorList(Consumer<PartitionIndexDescriptor.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

