/*
 * Decompiled with CFR 0.152.
 */
package com.github.pagehelper.dialect.helper;

import com.github.pagehelper.Page;
import com.github.pagehelper.cache.Cache;
import com.github.pagehelper.cache.CacheFactory;
import com.github.pagehelper.dialect.AbstractHelperDialect;
import com.github.pagehelper.dialect.ReplaceSql;
import com.github.pagehelper.dialect.replace.RegexWithNolockReplaceSql;
import com.github.pagehelper.dialect.replace.SimpleWithNolockReplaceSql;
import com.github.pagehelper.parser.SqlServerSqlParser;
import com.github.pagehelper.parser.defaults.DefaultSqlServerSqlParser;
import com.github.pagehelper.util.ClassUtil;
import com.github.pagehelper.util.StringUtil;
import java.util.Map;
import java.util.Properties;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.session.RowBounds;

public class SqlServerDialect
extends AbstractHelperDialect {
    protected SqlServerSqlParser sqlServerSqlParser;
    protected Cache<String, String> CACHE_COUNTSQL;
    protected Cache<String, String> CACHE_PAGESQL;
    protected ReplaceSql replaceSql;

    @Override
    public String getCountSql(MappedStatement ms, BoundSql boundSql, Object parameterObject, RowBounds rowBounds, CacheKey countKey) {
        String sql = boundSql.getSql();
        String cacheSql = this.CACHE_COUNTSQL.get(sql);
        if (cacheSql != null) {
            return cacheSql;
        }
        cacheSql = sql;
        cacheSql = this.replaceSql.replace(cacheSql);
        cacheSql = this.countSqlParser.getSmartCountSql(cacheSql);
        cacheSql = this.replaceSql.restore(cacheSql);
        this.CACHE_COUNTSQL.put(sql, cacheSql);
        return cacheSql;
    }

    @Override
    public Object processPageParameter(MappedStatement ms, Map<String, Object> paramMap, Page page, BoundSql boundSql, CacheKey pageKey) {
        return paramMap;
    }

    @Override
    public String getPageSql(String sql, Page page, CacheKey pageKey) {
        pageKey.update((Object)page.getStartRow());
        pageKey.update((Object)page.getPageSize());
        String cacheSql = this.CACHE_PAGESQL.get(sql);
        if (cacheSql == null) {
            cacheSql = sql;
            cacheSql = this.replaceSql.replace(cacheSql);
            cacheSql = this.sqlServerSqlParser.convertToPageSql(cacheSql, null, null);
            cacheSql = this.replaceSql.restore(cacheSql);
            this.CACHE_PAGESQL.put(sql, cacheSql);
        }
        cacheSql = cacheSql.replace(String.valueOf(Long.MIN_VALUE), String.valueOf(page.getStartRow()));
        cacheSql = cacheSql.replace(String.valueOf(Long.MAX_VALUE), String.valueOf(page.getPageSize()));
        return cacheSql;
    }

    @Override
    public String getPageSql(MappedStatement ms, BoundSql boundSql, Object parameterObject, RowBounds rowBounds, CacheKey pageKey) {
        String sql = boundSql.getSql();
        Page page = this.getLocalPage();
        String orderBy = page.getOrderBy();
        if (StringUtil.isNotEmpty(orderBy)) {
            pageKey.update((Object)orderBy);
            sql = this.replaceSql.replace(sql);
            sql = this.orderBySqlParser.converToOrderBySql(sql, orderBy);
            sql = this.replaceSql.restore(sql);
        }
        return page.isOrderByOnly() ? sql : this.getPageSql(sql, page, pageKey);
    }

    @Override
    public void setProperties(Properties properties) {
        super.setProperties(properties);
        this.sqlServerSqlParser = ClassUtil.newInstance(properties.getProperty("sqlServerSqlParser"), SqlServerSqlParser.class, properties, DefaultSqlServerSqlParser::new);
        String replaceSql = properties.getProperty("replaceSql");
        this.replaceSql = StringUtil.isEmpty(replaceSql) || "regex".equalsIgnoreCase(replaceSql) ? new RegexWithNolockReplaceSql() : ("simple".equalsIgnoreCase(replaceSql) ? new SimpleWithNolockReplaceSql() : (ReplaceSql)ClassUtil.newInstance(replaceSql, properties));
        String sqlCacheClass = properties.getProperty("sqlCacheClass");
        if (StringUtil.isNotEmpty(sqlCacheClass) && !sqlCacheClass.equalsIgnoreCase("false")) {
            this.CACHE_COUNTSQL = CacheFactory.createCache(sqlCacheClass, "count", properties);
            this.CACHE_PAGESQL = CacheFactory.createCache(sqlCacheClass, "page", properties);
        } else {
            this.CACHE_COUNTSQL = CacheFactory.createCache(null, "count", properties);
            this.CACHE_PAGESQL = CacheFactory.createCache(null, "page", properties);
        }
    }
}

