/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.hive.utils;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.amoro.hive.HMSClientPool;
import org.apache.amoro.hive.catalog.MixedHiveCatalog;
import org.apache.amoro.hive.table.SupportHive;
import org.apache.amoro.hive.table.UnkeyedHiveTable;
import org.apache.amoro.hive.utils.HiveMetaSynchronizer;
import org.apache.amoro.hive.utils.HivePartitionUtil;
import org.apache.amoro.hive.utils.HiveSchemaUtil;
import org.apache.amoro.hive.utils.HiveTableUtil;
import org.apache.amoro.io.AuthenticatedHadoopFileIO;
import org.apache.amoro.op.UpdatePartitionProperties;
import org.apache.amoro.shade.guava32.com.google.common.annotations.VisibleForTesting;
import org.apache.amoro.table.MixedTable;
import org.apache.amoro.table.PrimaryKeySpec;
import org.apache.amoro.table.TableIdentifier;
import org.apache.amoro.utils.TablePropertyUtil;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeHiveTableUtil {
    private static final Logger LOG = LoggerFactory.getLogger(UpgradeHiveTableUtil.class);
    private static final long DEFAULT_TXID = 0L;

    public static void upgradeHiveTable(MixedHiveCatalog mixedHiveCatalog, TableIdentifier tableIdentifier, List<String> pkList, Map<String, String> properties) throws Exception {
        if (!UpgradeHiveTableUtil.formatCheck(mixedHiveCatalog.getHMSClient(), tableIdentifier, properties)) {
            throw new IllegalArgumentException("The storage format is not support");
        }
        boolean upgradeHive = false;
        try {
            Table hiveTable = HiveTableUtil.loadHmsTable(mixedHiveCatalog.getHMSClient(), tableIdentifier);
            Schema schema = HiveSchemaUtil.convertHiveSchemaToIcebergSchema(hiveTable, pkList);
            List partitionKeys = hiveTable.getPartitionKeys();
            PartitionSpec.Builder partitionBuilder = PartitionSpec.builderFor((Schema)schema);
            partitionKeys.stream().forEach(p -> partitionBuilder.identity(p.getName()));
            PrimaryKeySpec.Builder primaryKeyBuilder = PrimaryKeySpec.builderFor((Schema)schema);
            pkList.stream().forEach(p -> primaryKeyBuilder.addColumn(p));
            MixedTable mixedTable = mixedHiveCatalog.newTableBuilder(tableIdentifier, schema).withProperties(properties).withPartitionSpec(partitionBuilder.build()).withPrimaryKeySpec(primaryKeyBuilder.build()).withProperty("allow-hive-table-existed", "true").create();
            upgradeHive = true;
            UpgradeHiveTableUtil.hiveDataMigration((SupportHive)mixedTable, mixedHiveCatalog, tableIdentifier);
        }
        catch (Throwable t) {
            if (upgradeHive) {
                mixedHiveCatalog.dropTable(tableIdentifier, false);
            }
            throw t;
        }
    }

    private static void hiveDataMigration(SupportHive mixedHiveTable, MixedHiveCatalog mixedHiveCatalog, TableIdentifier tableIdentifier) throws Exception {
        Table hiveTable = HiveTableUtil.loadHmsTable(mixedHiveCatalog.getHMSClient(), tableIdentifier);
        String hiveDataLocation = HiveTableUtil.hiveRootLocation(hiveTable.getSd().getLocation());
        AuthenticatedHadoopFileIO io = mixedHiveTable.io();
        io.makeDirectories(hiveDataLocation);
        if (hiveTable.getPartitionKeys().isEmpty()) {
            String newPath = hiveDataLocation + "/" + System.currentTimeMillis() + "_" + UUID.randomUUID();
            io.makeDirectories(newPath);
            io.listDirectory(hiveTable.getSd().getLocation()).forEach(p -> {
                if (!p.isDirectory()) {
                    io.asFileSystemIO().rename(p.location(), newPath);
                }
            });
            try {
                HiveTableUtil.alterTableLocation(mixedHiveCatalog.getHMSClient(), mixedHiveTable.id(), newPath);
                LOG.info("Table {} alter hive table location {}", (Object)mixedHiveTable.name(), (Object)hiveDataLocation);
            }
            catch (IOException e) {
                LOG.warn("Table {} alter hive table location failed", (Object)mixedHiveTable.name(), (Object)e);
                throw new RuntimeException(e);
            }
        } else {
            List<String> partitions = HivePartitionUtil.getHivePartitionNames(mixedHiveCatalog.getHMSClient(), tableIdentifier);
            List<String> partitionLocations = HivePartitionUtil.getHivePartitionLocations(mixedHiveCatalog.getHMSClient(), tableIdentifier);
            for (int i = 0; i < partitionLocations.size(); ++i) {
                String partition = partitions.get(i);
                String oldLocation = partitionLocations.get(i);
                String newLocation = hiveDataLocation + "/" + partition + "/" + HiveTableUtil.newHiveSubdirectory(0L);
                io.makeDirectories(newLocation);
                io.listDirectory(oldLocation).forEach(p -> {
                    if (!p.isDirectory()) {
                        io.asFileSystemIO().rename(p.location(), newLocation);
                    }
                });
                HivePartitionUtil.alterPartition(mixedHiveCatalog.getHMSClient(), tableIdentifier, partition, newLocation);
            }
        }
        HiveMetaSynchronizer.syncHiveDataToMixedTable(mixedHiveTable, mixedHiveCatalog.getHMSClient());
        hiveTable = HiveTableUtil.loadHmsTable(mixedHiveCatalog.getHMSClient(), tableIdentifier);
        UpgradeHiveTableUtil.fillPartitionProperties(mixedHiveTable, mixedHiveCatalog, hiveTable);
    }

    private static boolean formatCheck(HMSClientPool hiveClient, TableIdentifier tableIdentifier, Map<String, String> properties) throws IOException {
        AtomicBoolean isSupport = new AtomicBoolean(false);
        try {
            hiveClient.run(client -> {
                Table hiveTable = HiveTableUtil.loadHmsTable(hiveClient, tableIdentifier);
                StorageDescriptor storageDescriptor = hiveTable.getSd();
                SerDeInfo serDeInfo = storageDescriptor.getSerdeInfo();
                switch (storageDescriptor.getInputFormat()) {
                    case "org.apache.hadoop.hive.ql.io.parquet.MapredParquetInputFormat": {
                        if (storageDescriptor.getOutputFormat().equals("org.apache.hadoop.hive.ql.io.parquet.MapredParquetOutputFormat") && serDeInfo.getSerializationLib().equals("org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe")) {
                            properties.put("write.format.default", "parquet");
                            properties.put("base.write.format", "parquet");
                            properties.put("change.write.format", "parquet");
                            isSupport.set(true);
                            break;
                        }
                        throw new IllegalStateException("Please check your hive table storage format for parquet is right");
                    }
                    case "org.apache.hadoop.hive.ql.io.orc.OrcInputFormat": {
                        if (storageDescriptor.getOutputFormat().equals("org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat") && serDeInfo.getSerializationLib().equals("org.apache.hadoop.hive.ql.io.orc.OrcSerde")) {
                            properties.put("write.format.default", "orc");
                            properties.put("base.write.format", "orc");
                            properties.put("change.write.format", "orc");
                            isSupport.set(true);
                            break;
                        }
                        throw new IllegalStateException("Please check your hive table storage format for orc is right");
                    }
                    default: {
                        isSupport.set(false);
                    }
                }
                return null;
            });
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        return isSupport.get();
    }

    @VisibleForTesting
    static void fillPartitionProperties(MixedTable table, MixedHiveCatalog mixedHiveCatalog, Table hiveTable) {
        UnkeyedHiveTable baseTable = table.isKeyedTable() ? (UnkeyedHiveTable)table.asKeyedTable().baseTable() : (UnkeyedHiveTable)table.asUnkeyedTable();
        UpdatePartitionProperties updatePartitionProperties = baseTable.updatePartitionProperties(null);
        if (table.spec().isUnpartitioned()) {
            if (UpgradeHiveTableUtil.hasPartitionProperties(baseTable, false, null)) {
                return;
            }
            updatePartitionProperties.set(TablePropertyUtil.EMPTY_STRUCT, "hive-location", baseTable.hiveLocation());
            updatePartitionProperties.set(TablePropertyUtil.EMPTY_STRUCT, "transient-time", (String)hiveTable.getParameters().get("transient_lastDdlTime"));
        } else {
            List<Partition> partitions = HivePartitionUtil.getHiveAllPartitions(mixedHiveCatalog.getHMSClient(), table.id());
            partitions.forEach(partition -> {
                StructLike partitionData = HivePartitionUtil.buildPartitionData(partition.getValues(), table.spec());
                if (UpgradeHiveTableUtil.hasPartitionProperties(baseTable, true, partitionData)) {
                    return;
                }
                updatePartitionProperties.set(partitionData, "hive-location", partition.getSd().getLocation());
                updatePartitionProperties.set(partitionData, "transient-time", (String)partition.getParameters().get("transient_lastDdlTime"));
            });
        }
        updatePartitionProperties.commit();
    }

    private static boolean hasPartitionProperties(UnkeyedHiveTable baseTable, boolean isPartitioned, StructLike partitionData) {
        Map partitionProperties = isPartitioned ? (Map)baseTable.partitionProperty().get((Object)partitionData) : (Map)baseTable.partitionProperty().get((Object)TablePropertyUtil.EMPTY_STRUCT);
        return partitionProperties != null && partitionProperties.containsKey("hive-location") && partitionProperties.containsKey("transient-time");
    }
}

