/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.enumerable;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.adapter.enumerable.EnumerableConvention;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import org.apache.calcite.adapter.enumerable.EnumerableUnion;
import org.apache.calcite.adapter.enumerable.JavaRowFormat;
import org.apache.calcite.adapter.enumerable.PhysType;
import org.apache.calcite.adapter.enumerable.PhysTypeImpl;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.linq4j.tree.BlockBuilder;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.MethodCallExpression;
import org.apache.calcite.linq4j.tree.ParameterExpression;
import org.apache.calcite.linq4j.tree.Statement;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;

public class EnumerableMergeUnion
extends EnumerableUnion {
    protected EnumerableMergeUnion(RelOptCluster cluster, RelTraitSet traitSet, List<RelNode> inputs, boolean all) {
        super(cluster, traitSet, inputs, all);
        Object collation = traitSet.getCollation();
        if (collation == null || collation.getFieldCollations().isEmpty()) {
            throw new IllegalArgumentException("EnumerableMergeUnion with no collation");
        }
        for (RelNode input : inputs) {
            Object inputCollation = input.getTraitSet().getCollation();
            if (inputCollation != null && inputCollation.satisfies((RelTrait)collation)) continue;
            throw new IllegalArgumentException("EnumerableMergeUnion input does not satisfy collation. EnumerableMergeUnion collation: " + collation + ". Input collation: " + inputCollation + ". Input: " + input);
        }
    }

    public static EnumerableMergeUnion create(RelCollation collation, List<RelNode> inputs, boolean all) {
        RelOptCluster cluster = inputs.get(0).getCluster();
        RelTraitSet traitSet = cluster.traitSetOf((RelTrait)EnumerableConvention.INSTANCE).replace(collation);
        return new EnumerableMergeUnion(cluster, traitSet, inputs, all);
    }

    @Override
    public EnumerableMergeUnion copy(RelTraitSet traitSet, List<RelNode> inputs, boolean all) {
        return new EnumerableMergeUnion(this.getCluster(), traitSet, inputs, all);
    }

    @Override
    public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
        BlockBuilder builder = new BlockBuilder();
        ParameterExpression inputListExp = Expressions.parameter(List.class, (String)builder.newName("mergeUnionInputs" + Integer.toUnsignedString(this.getId())));
        builder.add((Statement)Expressions.declare((int)0, (ParameterExpression)inputListExp, (Expression)Expressions.new_(ArrayList.class)));
        for (Ord ord : Ord.zip((List)this.inputs)) {
            EnumerableRel input = (EnumerableRel)ord.e;
            EnumerableRel.Result result = implementor.visitChild(this, ord.i, input, pref);
            Expression childExp = builder.append("child" + ord.i, result.block);
            builder.add(Expressions.statement((Expression)Expressions.call((Expression)inputListExp, (Method)BuiltInMethod.COLLECTION_ADD.method, (Expression[])new Expression[]{childExp})));
        }
        PhysType physType = PhysTypeImpl.of(implementor.getTypeFactory(), this.getRowType(), pref.prefer(JavaRowFormat.CUSTOM));
        Object collation = this.getTraitSet().getCollation();
        if (collation == null || collation.getFieldCollations().isEmpty()) {
            throw new IllegalStateException("EnumerableMergeUnion with no collation");
        }
        Pair<Expression, Expression> pair = physType.generateCollationKey(collation.getFieldCollations());
        Expression sortKeySelector = (Expression)pair.left;
        Expression sortComparator = (Expression)pair.right;
        Expression equalityComparator = (Expression)Util.first(physType.comparer(), Expressions.call((Method)BuiltInMethod.IDENTITY_COMPARER.method, (Expression[])new Expression[0]));
        MethodCallExpression unionExp = Expressions.call((Method)BuiltInMethod.MERGE_UNION.method, (Expression[])new Expression[]{inputListExp, sortKeySelector, sortComparator, Expressions.constant((Object)this.all, Boolean.TYPE), equalityComparator});
        builder.add((Expression)unionExp);
        return implementor.result(physType, builder.toBlock());
    }
}

