/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.apache.hc.core5.http.ConnectionClosedException;
import org.apache.hc.core5.http.StreamClosedException;
import org.apache.hc.core5.http.impl.io.ContentLengthInputStream;
import org.apache.hc.core5.http.impl.io.SessionInputBufferImpl;
import org.apache.hc.core5.http.io.SessionInputBuffer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestContentLengthInputStream {
    TestContentLengthInputStream() {
    }

    @Test
    void testBasics() throws IOException {
        String s = "1234567890123456";
        ByteArrayInputStream inputStream = new ByteArrayInputStream("1234567890123456".getBytes(StandardCharsets.US_ASCII));
        SessionInputBufferImpl inBuffer = new SessionInputBufferImpl(16);
        try (ContentLengthInputStream in = new ContentLengthInputStream((SessionInputBuffer)inBuffer, (InputStream)inputStream, 10L);){
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            byte[] buffer = new byte[50];
            int len = in.read(buffer, 0, 2);
            outputStream.write(buffer, 0, len);
            len = in.read(buffer);
            outputStream.write(buffer, 0, len);
            String result = new String(outputStream.toByteArray(), StandardCharsets.US_ASCII);
            Assertions.assertEquals((Object)"1234567890", (Object)result);
        }
    }

    @Test
    void testSkip() throws IOException {
        ByteArrayInputStream inputStream1 = new ByteArrayInputStream(new byte[20]);
        SessionInputBufferImpl inBuffer1 = new SessionInputBufferImpl(16);
        try (ContentLengthInputStream in1 = new ContentLengthInputStream((SessionInputBuffer)inBuffer1, (InputStream)inputStream1, 10L);){
            Assertions.assertEquals((long)10L, (long)in1.skip(10L));
            Assertions.assertEquals((int)-1, (int)in1.read());
        }
        ByteArrayInputStream inputStream2 = new ByteArrayInputStream(new byte[20]);
        SessionInputBufferImpl inBuffer2 = new SessionInputBufferImpl(16);
        try (ContentLengthInputStream in2 = new ContentLengthInputStream((SessionInputBuffer)inBuffer2, (InputStream)inputStream2, 10L);){
            in2.read();
            Assertions.assertEquals((long)9L, (long)in2.skip(10L));
            Assertions.assertEquals((int)-1, (int)in2.read());
        }
        ByteArrayInputStream inputStream3 = new ByteArrayInputStream(new byte[20]);
        SessionInputBufferImpl inBuffer3 = new SessionInputBufferImpl(16);
        try (ContentLengthInputStream in3 = new ContentLengthInputStream((SessionInputBuffer)inBuffer3, (InputStream)inputStream3, 2L);){
            in3.read();
            in3.read();
            Assertions.assertTrue((in3.skip(10L) <= 0L ? 1 : 0) != 0);
            Assertions.assertEquals((long)0L, (long)in3.skip(-1L));
            Assertions.assertEquals((int)-1, (int)in3.read());
        }
        ByteArrayInputStream inputStream4 = new ByteArrayInputStream(new byte[20]);
        SessionInputBufferImpl inBuffer4 = new SessionInputBufferImpl(16);
        try (ContentLengthInputStream in4 = new ContentLengthInputStream((SessionInputBuffer)inBuffer4, (InputStream)inputStream4, 10L);){
            Assertions.assertEquals((long)5L, (long)in4.skip(5L));
            Assertions.assertEquals((int)5, (int)in4.read(new byte[20]));
        }
    }

    @Test
    void testAvailable() throws IOException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(new byte[]{1, 2, 3});
        SessionInputBufferImpl inBuffer = new SessionInputBufferImpl(16);
        try (ContentLengthInputStream in = new ContentLengthInputStream((SessionInputBuffer)inBuffer, (InputStream)inputStream, 3L);){
            Assertions.assertEquals((int)0, (int)in.available());
            in.read();
            Assertions.assertEquals((int)2, (int)in.available());
        }
    }

    @Test
    void testClose() throws IOException {
        String s = "1234567890123456-";
        ByteArrayInputStream inputStream = new ByteArrayInputStream("1234567890123456-".getBytes(StandardCharsets.US_ASCII));
        SessionInputBufferImpl inBuffer = new SessionInputBufferImpl(16);
        ContentLengthInputStream in = new ContentLengthInputStream((SessionInputBuffer)inBuffer, (InputStream)inputStream, 16L);
        in.close();
        in.close();
        Assertions.assertThrows(StreamClosedException.class, ((InputStream)in)::read);
        byte[] tmp = new byte[10];
        Assertions.assertThrows(StreamClosedException.class, () -> TestContentLengthInputStream.lambda$testClose$0((InputStream)in, tmp));
        Assertions.assertThrows(StreamClosedException.class, () -> TestContentLengthInputStream.lambda$testClose$1((InputStream)in, tmp));
        Assertions.assertEquals((int)45, (int)inBuffer.read((InputStream)inputStream));
    }

    @Test
    void testTruncatedContent() throws IOException {
        String s = "1234567890123456";
        ByteArrayInputStream inputStream = new ByteArrayInputStream("1234567890123456".getBytes(StandardCharsets.US_ASCII));
        SessionInputBufferImpl inBuffer = new SessionInputBufferImpl(16);
        ContentLengthInputStream in = new ContentLengthInputStream((SessionInputBuffer)inBuffer, (InputStream)inputStream, 32L);
        byte[] tmp = new byte[32];
        int byteRead = in.read(tmp);
        Assertions.assertEquals((int)16, (int)byteRead);
        Assertions.assertThrows(ConnectionClosedException.class, () -> TestContentLengthInputStream.lambda$testTruncatedContent$2((InputStream)in, tmp));
        Assertions.assertThrows(ConnectionClosedException.class, () -> TestContentLengthInputStream.lambda$testTruncatedContent$3((InputStream)in));
        Assertions.assertThrows(ConnectionClosedException.class, () -> TestContentLengthInputStream.lambda$testTruncatedContent$4((InputStream)in));
    }

    private static /* synthetic */ void lambda$testTruncatedContent$4(InputStream in) throws Throwable {
        in.close();
    }

    private static /* synthetic */ void lambda$testTruncatedContent$3(InputStream in) throws Throwable {
        in.read();
    }

    private static /* synthetic */ void lambda$testTruncatedContent$2(InputStream in, byte[] tmp) throws Throwable {
        in.read(tmp);
    }

    private static /* synthetic */ void lambda$testClose$1(InputStream in, byte[] tmp) throws Throwable {
        in.read(tmp, 0, tmp.length);
    }

    private static /* synthetic */ void lambda$testClose$0(InputStream in, byte[] tmp) throws Throwable {
        in.read(tmp);
    }
}

