/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.reactor;

import org.apache.hc.core5.reactor.IOWorkerSelector;
import org.apache.hc.core5.reactor.IOWorkerSelectors;
import org.apache.hc.core5.reactor.IOWorkerStats;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.Mockito;

class IOWorkerSelectorsTest {
    IOWorkerSelectorsTest() {
    }

    @ParameterizedTest(name="worker count = {0}")
    @ValueSource(ints={1, 2, 3, 4, 5, 10, 15, 16, 32})
    void testIndexOverflow(int workerCount) {
        long start = 0x7FFFFFF5L;
        long end = 0x80000009L;
        IOWorkerStats[] workers = new IOWorkerStats[workerCount];
        for (int i = 0; i < workerCount; ++i) {
            workers[i] = (IOWorkerStats)Mockito.mock(IOWorkerStats.class);
        }
        IOWorkerSelector selector = IOWorkerSelectors.newSelector((int)workerCount, (int)0x7FFFFFF5);
        for (long i = 0x7FFFFFF5L; i < 0x80000009L; ++i) {
            Assertions.assertTrue((selector.select(workers) < workerCount ? 1 : 0) != 0);
        }
    }
}

