/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.maybe;

import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.MaybeObserver;
import io.reactivex.rxjava3.core.MaybeSource;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.operators.maybe.MaybeMap;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class MaybeZipArray<T, R>
extends Maybe<R> {
    final MaybeSource<? extends T>[] sources;
    final Function<? super Object[], ? extends R> zipper;

    public MaybeZipArray(MaybeSource<? extends T>[] sources, Function<? super Object[], ? extends R> zipper) {
        this.sources = sources;
        this.zipper = zipper;
    }

    @Override
    protected void subscribeActual(MaybeObserver<? super R> observer) {
        MaybeSource<? extends T>[] sources = this.sources;
        int n = sources.length;
        if (n == 1) {
            sources[0].subscribe(new MaybeMap.MapMaybeObserver(observer, new SingletonArrayFunc()));
            return;
        }
        ZipCoordinator parent = new ZipCoordinator(observer, n, this.zipper);
        observer.onSubscribe(parent);
        for (int i = 0; i < n; ++i) {
            if (parent.isDisposed()) {
                return;
            }
            MaybeSource source = sources[i];
            if (source == null) {
                parent.innerError(new NullPointerException("One of the sources is null"), i);
                return;
            }
            source.subscribe(parent.observers[i]);
        }
    }

    final class SingletonArrayFunc
    implements Function<T, R> {
        SingletonArrayFunc() {
        }

        @Override
        public R apply(T t) throws Throwable {
            return Objects.requireNonNull(MaybeZipArray.this.zipper.apply((Object[])new Object[]{t}), "The zipper returned a null value");
        }
    }

    static final class ZipMaybeObserver<T>
    extends AtomicReference<Disposable>
    implements MaybeObserver<T> {
        private static final long serialVersionUID = 3323743579927613702L;
        final ZipCoordinator<T, ?> parent;
        final int index;

        ZipMaybeObserver(ZipCoordinator<T, ?> parent, int index) {
            this.parent = parent;
            this.index = index;
        }

        public void dispose() {
            DisposableHelper.dispose(this);
        }

        @Override
        public void onSubscribe(Disposable d) {
            DisposableHelper.setOnce(this, d);
        }

        @Override
        public void onSuccess(T value) {
            this.parent.innerSuccess(value, this.index);
        }

        @Override
        public void onError(Throwable e) {
            this.parent.innerError(e, this.index);
        }

        @Override
        public void onComplete() {
            this.parent.innerComplete(this.index);
        }
    }

    static final class ZipCoordinator<T, R>
    extends AtomicInteger
    implements Disposable {
        private static final long serialVersionUID = -5556924161382950569L;
        final MaybeObserver<? super R> downstream;
        final Function<? super Object[], ? extends R> zipper;
        final ZipMaybeObserver<T>[] observers;
        Object[] values;

        ZipCoordinator(MaybeObserver<? super R> observer, int n, Function<? super Object[], ? extends R> zipper) {
            super(n);
            this.downstream = observer;
            this.zipper = zipper;
            ZipMaybeObserver[] o = new ZipMaybeObserver[n];
            for (int i = 0; i < n; ++i) {
                o[i] = new ZipMaybeObserver(this, i);
            }
            this.observers = o;
            this.values = new Object[n];
        }

        @Override
        public boolean isDisposed() {
            return this.get() <= 0;
        }

        @Override
        public void dispose() {
            if (this.getAndSet(0) > 0) {
                for (ZipMaybeObserver<T> d : this.observers) {
                    d.dispose();
                }
                this.values = null;
            }
        }

        void innerSuccess(T value, int index) {
            Object[] values = this.values;
            if (values != null) {
                values[index] = value;
            }
            if (this.decrementAndGet() == 0) {
                R v;
                try {
                    v = Objects.requireNonNull(this.zipper.apply((Object[])values), "The zipper returned a null value");
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    this.values = null;
                    this.downstream.onError(ex);
                    return;
                }
                this.values = null;
                this.downstream.onSuccess(v);
            }
        }

        void disposeExcept(int index) {
            int i;
            ZipMaybeObserver<T>[] observers = this.observers;
            int n = observers.length;
            for (i = 0; i < index; ++i) {
                observers[i].dispose();
            }
            for (i = index + 1; i < n; ++i) {
                observers[i].dispose();
            }
        }

        void innerError(Throwable ex, int index) {
            if (this.getAndSet(0) > 0) {
                this.disposeExcept(index);
                this.values = null;
                this.downstream.onError(ex);
            } else {
                RxJavaPlugins.onError(ex);
            }
        }

        void innerComplete(int index) {
            if (this.getAndSet(0) > 0) {
                this.disposeExcept(index);
                this.values = null;
                this.downstream.onComplete();
            }
        }
    }
}

