/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl.nio;

import org.apache.hc.core5.http.impl.nio.ExpandableBuffer;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Test;

class TestExpandableBuffer {
    TestExpandableBuffer() {
    }

    @Test
    void testBasics() {
        ExpandableBuffer buffer = new ExpandableBuffer(16);
        MatcherAssert.assertThat((Object)buffer.mode(), (Matcher)CoreMatchers.equalTo((Object)ExpandableBuffer.Mode.INPUT));
        MatcherAssert.assertThat((Object)buffer.hasData(), (Matcher)CoreMatchers.equalTo((Object)false));
        buffer.setInputMode();
        buffer.buffer().put(new byte[]{0, 1, 2, 3, 4, 5});
        MatcherAssert.assertThat((Object)buffer.hasData(), (Matcher)CoreMatchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)buffer.length(), (Matcher)CoreMatchers.equalTo((Object)6));
        MatcherAssert.assertThat((Object)buffer.buffer().capacity(), (Matcher)CoreMatchers.equalTo((Object)16));
        MatcherAssert.assertThat((Object)buffer.mode(), (Matcher)CoreMatchers.equalTo((Object)ExpandableBuffer.Mode.OUTPUT));
        buffer.setInputMode();
        buffer.buffer().put(new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9});
        MatcherAssert.assertThat((Object)buffer.length(), (Matcher)CoreMatchers.equalTo((Object)16));
        MatcherAssert.assertThat((Object)buffer.buffer().capacity(), (Matcher)CoreMatchers.equalTo((Object)16));
        MatcherAssert.assertThat((Object)buffer.mode(), (Matcher)CoreMatchers.equalTo((Object)ExpandableBuffer.Mode.OUTPUT));
        buffer.setInputMode();
        buffer.ensureCapacity(22);
        buffer.buffer().put(new byte[]{0, 1, 2, 3, 4, 5});
        MatcherAssert.assertThat((Object)buffer.length(), (Matcher)CoreMatchers.equalTo((Object)22));
        MatcherAssert.assertThat((Object)buffer.buffer().capacity(), (Matcher)CoreMatchers.equalTo((Object)22));
        MatcherAssert.assertThat((Object)buffer.mode(), (Matcher)CoreMatchers.equalTo((Object)ExpandableBuffer.Mode.OUTPUT));
        buffer.clear();
        MatcherAssert.assertThat((Object)buffer.mode(), (Matcher)CoreMatchers.equalTo((Object)ExpandableBuffer.Mode.INPUT));
        MatcherAssert.assertThat((Object)buffer.hasData(), (Matcher)CoreMatchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)buffer.capacity(), (Matcher)CoreMatchers.equalTo((Object)22));
    }

    @Test
    void testAdjustCapacity() {
        ExpandableBuffer buffer = new ExpandableBuffer(16);
        MatcherAssert.assertThat((Object)buffer.capacity(), (Matcher)CoreMatchers.equalTo((Object)16));
        buffer.ensureCapacity(21);
        MatcherAssert.assertThat((Object)buffer.capacity(), (Matcher)CoreMatchers.equalTo((Object)21));
        buffer.ensureAdjustedCapacity(22);
        MatcherAssert.assertThat((Object)buffer.capacity(), (Matcher)CoreMatchers.equalTo((Object)1024));
        buffer.ensureAdjustedCapacity(1024);
        MatcherAssert.assertThat((Object)buffer.capacity(), (Matcher)CoreMatchers.equalTo((Object)1024));
        buffer.ensureAdjustedCapacity(1025);
        MatcherAssert.assertThat((Object)buffer.capacity(), (Matcher)CoreMatchers.equalTo((Object)2048));
    }
}

