/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.tool.BulkLoadHFiles;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.hbase.HBCK2;
import org.apache.hbase.HBCKFsUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MissingRegionDirsRepairTool
extends Configured
implements Tool {
    private static final Logger LOG = LoggerFactory.getLogger(MissingRegionDirsRepairTool.class.getName());
    private static final String WORKING_DIR = ".missing_dirs_repair";
    private Configuration conf;
    private HBCK2 hbck;
    private BulkLoadHFiles bulkLoad;

    public MissingRegionDirsRepairTool(Configuration conf) {
        this.conf = conf;
        this.hbck = new HBCK2(conf);
        this.bulkLoad = BulkLoadHFiles.create((Configuration)conf);
    }

    public int run(String[] strings) throws Exception {
        Map<TableName, List<Path>> result = this.hbck.reportTablesWithMissingRegionsInMeta(new String[0]);
        Path runPath = new Path(new Path(HBCKFsUtils.getRootDir(this.conf), WORKING_DIR), "" + System.currentTimeMillis());
        FileSystem fs = runPath.getFileSystem(this.conf);
        LOG.info("creating temp dir at: " + runPath.getName());
        fs.mkdirs(runPath);
        try (Connection conn = ConnectionFactory.createConnection((Configuration)this.conf);){
            Admin admin = conn.getAdmin();
            result.forEach((t, p) -> {
                if (!p.isEmpty()) {
                    Path tblPath = new Path(runPath, new Path(t.getNameWithNamespaceInclAsString().replaceAll(":", "_")));
                    try {
                        fs.mkdirs(tblPath);
                        Path sidelined = new Path(tblPath, "sidelined");
                        fs.mkdirs(sidelined);
                        Path bulkload = new Path(tblPath, "bulkload");
                        fs.mkdirs(bulkload);
                        p.stream().forEach(region -> {
                            try {
                                Path sidelinedRegionDir = new Path(sidelined, region.getName());
                                fs.mkdirs(sidelinedRegionDir);
                                HBCKFsUtils.copyFilesParallel(fs, region, fs, sidelinedRegionDir, this.conf, 3);
                                admin.getDescriptor(t).getColumnFamilyNames().forEach(cf -> {
                                    Path cfDir = new Path(region, Bytes.toString((byte[])cf));
                                    Path tempCfDir = new Path(bulkload, cfDir.getName());
                                    try {
                                        FileStatus[] files;
                                        if (!fs.exists(tempCfDir)) {
                                            fs.mkdirs(tempCfDir);
                                        }
                                        for (FileStatus file : files = fs.listStatus(cfDir)) {
                                            fs.rename(file.getPath(), new Path(tempCfDir, region.getName() + "-" + file.getPath().getName()));
                                        }
                                    }
                                    catch (IOException e) {
                                        LOG.error("Error trying to move files from inconsistent region dir: ", e);
                                    }
                                });
                                fs.delete(region, true);
                                LOG.info("region dir {} moved to {}", (Object)region.toUri().getRawPath(), (Object)sidelinedRegionDir.toUri().getRawPath());
                            }
                            catch (IOException e) {
                                LOG.error("Error trying to fetch table descriptor: ", e);
                            }
                        });
                        LOG.info("Calling bulk load for: " + tblPath.toUri().getRawPath());
                        this.bulkLoad.bulkLoad(t, bulkload);
                    }
                    catch (IOException e) {
                        LOG.error("Error trying to create temp dir for sideline files: ", e);
                    }
                }
            });
            admin.close();
        }
        return 0;
    }

    public static void main(String[] args) throws Exception {
        Configuration conf = HBaseConfiguration.create();
        int errCode = ToolRunner.run((Tool)new MissingRegionDirsRepairTool(conf), (String[])args);
        if (errCode != 0) {
            System.exit(errCode);
        }
    }
}

