/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.nio.ByteBuffer;
import org.apache.hadoop.hbase.ipc.NettyHBaseSaslRpcServerHandler;
import org.apache.hadoop.hbase.ipc.NettyRpcServer;
import org.apache.hadoop.hbase.ipc.NettyServerRpcConnection;
import org.apache.hadoop.hbase.ipc.ServerRpcConnection;
import org.apache.hadoop.hbase.util.NettyFutureUtils;
import org.apache.hbase.thirdparty.io.netty.buffer.ByteBuf;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelHandler;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelHandlerContext;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelOutboundInvoker;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelPipeline;
import org.apache.hbase.thirdparty.io.netty.channel.SimpleChannelInboundHandler;
import org.apache.hbase.thirdparty.io.netty.handler.codec.FixedLengthFrameDecoder;
import org.apache.hbase.thirdparty.io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class NettyRpcServerPreambleHandler
extends SimpleChannelInboundHandler<ByteBuf> {
    static final String DECODER_NAME = "preambleDecoder";
    private final NettyRpcServer rpcServer;
    private final NettyServerRpcConnection conn;
    private boolean processPreambleError;

    public NettyRpcServerPreambleHandler(NettyRpcServer rpcServer, NettyServerRpcConnection conn) {
        this.rpcServer = rpcServer;
        this.conn = conn;
    }

    static FixedLengthFrameDecoder createDecoder() {
        FixedLengthFrameDecoder preambleDecoder = new FixedLengthFrameDecoder(6);
        preambleDecoder.setSingleDecode(true);
        return preambleDecoder;
    }

    protected void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) throws Exception {
        if (this.processPreambleError) {
            return;
        }
        ByteBuffer buf = ByteBuffer.allocate(msg.readableBytes());
        msg.readBytes(buf);
        buf.flip();
        ServerRpcConnection.PreambleResponse resp = this.conn.processPreamble(buf);
        if (resp == ServerRpcConnection.PreambleResponse.CLOSE) {
            this.processPreambleError = true;
            this.conn.close();
            return;
        }
        if (resp == ServerRpcConnection.PreambleResponse.CONTINUE) {
            ctx.pipeline().replace(DECODER_NAME, DECODER_NAME, (ChannelHandler)NettyRpcServerPreambleHandler.createDecoder());
            return;
        }
        ChannelPipeline p = ctx.pipeline();
        if (this.conn.useSasl) {
            LengthFieldBasedFrameDecoder decoder = new LengthFieldBasedFrameDecoder(Integer.MAX_VALUE, 0, 4, 0, 4);
            decoder.setSingleDecode(true);
            p.addBefore("NettyRpcServerResponseEncoder", "SaslNegotiationDecoder", (ChannelHandler)decoder).addBefore("NettyRpcServerResponseEncoder", null, (ChannelHandler)new NettyHBaseSaslRpcServerHandler(this.rpcServer, this.conn));
        } else {
            this.conn.setupHandler();
        }
        p.remove((ChannelHandler)this);
        p.remove(DECODER_NAME);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        NettyRpcServer.LOG.warn("Connection {}; caught unexpected downstream exception.", (Object)ctx.channel().remoteAddress(), (Object)cause);
        NettyFutureUtils.safeClose((ChannelOutboundInvoker)ctx);
    }
}

