/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.namequeues;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.namequeues.MetricsWALEventTrackerSource;
import org.apache.hadoop.hbase.namequeues.MetricsWALEventTrackerSourceImpl;
import org.apache.hadoop.hbase.namequeues.WALEventTrackerPayload;
import org.apache.hadoop.hbase.namequeues.WALEventTrackerQueueService;
import org.apache.hadoop.hbase.namequeues.WALEventTrackerTableAccessor;
import org.apache.hadoop.hbase.regionserver.wal.WALEventTrackerListener;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@Category(value={SmallTests.class})
public class TestWalEventTrackerQueueService {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestWalEventTrackerQueueService.class);
    @Rule
    public TestName name = new TestName();

    @Test
    public void testMetrics() throws Exception {
        String rsName = "test-region-server";
        String walName = "test-wal-0";
        long timeStamp = EnvironmentEdgeManager.currentTime();
        String walState = WALEventTrackerListener.WalState.ACTIVE.name();
        long walLength = 100L;
        WALEventTrackerPayload payload = new WALEventTrackerPayload(rsName, walName, timeStamp, walState, walLength);
        Configuration conf = HBaseConfiguration.create();
        conf.setBoolean("hbase.regionserver.wal.event.tracker.enabled", true);
        conf.setLong("wal.event.tracker.sleep.interval.msec", 100L);
        MetricsWALEventTrackerSourceImpl source = new MetricsWALEventTrackerSourceImpl(this.name.getMethodName(), this.name.getMethodName(), this.name.getMethodName(), this.name.getMethodName());
        WALEventTrackerQueueService service = new WALEventTrackerQueueService(conf, (MetricsWALEventTrackerSource)source);
        service.addToQueue(payload);
        Connection mockConnection = (Connection)Mockito.mock(Connection.class);
        ((Connection)Mockito.doReturn((Object)conf).when((Object)mockConnection)).getConfiguration();
        ((Connection)Mockito.doThrow((Throwable[])new Throwable[]{new IOException()}).when((Object)mockConnection)).getTable(WALEventTrackerTableAccessor.WAL_EVENT_TRACKER_TABLE_NAME);
        Assert.assertEquals((long)0L, (long)source.getFailedPuts());
        Assert.assertEquals((long)0L, (long)source.getNumRecordsFailedPuts());
        service.persistAll(mockConnection);
        Assert.assertEquals((long)1L, (long)source.getFailedPuts());
        Assert.assertEquals((long)1L, (long)source.getNumRecordsFailedPuts());
        ((Connection)Mockito.verify((Object)mockConnection, (VerificationMode)Mockito.times((int)4))).getTable(WALEventTrackerTableAccessor.WAL_EVENT_TRACKER_TABLE_NAME);
    }
}

