/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.master;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class ReplicationSinkTrackerTableCreator {
    private static final Logger LOG = LoggerFactory.getLogger(ReplicationSinkTrackerTableCreator.class);
    private static final long TTL = TimeUnit.DAYS.toSeconds(365L);
    public static final byte[] RS_COLUMN = Bytes.toBytes("region_server_name");
    public static final byte[] WAL_NAME_COLUMN = Bytes.toBytes("wal_name");
    public static final byte[] TIMESTAMP_COLUMN = Bytes.toBytes("timestamp");
    public static final byte[] OFFSET_COLUMN = Bytes.toBytes("offset");
    public static final String REPLICATION_SINK_TRACKER_ENABLED_KEY = "hbase.regionserver.replication.sink.tracker.enabled";
    public static final boolean REPLICATION_SINK_TRACKER_ENABLED_DEFAULT = false;
    private static final String REPLICATION_SINK_TRACKER_INFO_FAMILY_STR = "info";
    public static final byte[] REPLICATION_SINK_TRACKER_INFO_FAMILY = Bytes.toBytes("info");
    public static final String REPLICATION_SINK_TRACKER_TABLE_NAME_STR = "REPLICATION.SINK_TRACKER";
    public static final TableName REPLICATION_SINK_TRACKER_TABLE_NAME = TableName.valueOf("REPLICATION.SINK_TRACKER");
    private static final TableDescriptorBuilder TABLE_DESCRIPTOR_BUILDER = TableDescriptorBuilder.newBuilder(REPLICATION_SINK_TRACKER_TABLE_NAME).setRegionReplication(1).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder(REPLICATION_SINK_TRACKER_INFO_FAMILY).setScope(0).setBlockCacheEnabled(false).setMaxVersions(1).setTimeToLive((int)TTL).build());

    private ReplicationSinkTrackerTableCreator() {
    }

    public static void createIfNeededAndNotExists(Configuration conf, MasterServices masterServices) throws IOException {
        boolean replicationSinkTrackerEnabled = conf.getBoolean(REPLICATION_SINK_TRACKER_ENABLED_KEY, false);
        if (!replicationSinkTrackerEnabled) {
            LOG.info("replication sink tracker requests logging to table {} is disabled. Quitting.", (Object)REPLICATION_SINK_TRACKER_TABLE_NAME_STR);
            return;
        }
        if (!masterServices.getTableDescriptors().exists(REPLICATION_SINK_TRACKER_TABLE_NAME)) {
            LOG.info("{} table not found. Creating.", (Object)REPLICATION_SINK_TRACKER_TABLE_NAME_STR);
            masterServices.createTable(TABLE_DESCRIPTOR_BUILDER.build(), null, 0L, 0L);
        }
    }
}

