/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mob;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.mob.MobUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class ExpiredMobFileCleaner
extends Configured
implements Tool {
    private static final Logger LOG = LoggerFactory.getLogger(ExpiredMobFileCleaner.class);

    public void cleanExpiredMobFiles(TableDescriptor htd, ColumnFamilyDescriptor family) throws IOException {
        Configuration conf = this.getConf();
        String tableName = htd.getTableName().getNameAsString();
        FileSystem fs = FileSystem.get((Configuration)conf);
        LOG.info("Cleaning the expired MOB files of " + family.getNameAsString() + " in " + tableName);
        Configuration copyOfConf = new Configuration(conf);
        copyOfConf.setFloat("hfile.block.cache.size", 0.0f);
        CacheConfig cacheConfig = new CacheConfig(copyOfConf);
        MobUtils.cleanExpiredMobFiles(fs, conf, htd, family, cacheConfig, EnvironmentEdgeManager.currentTime());
    }

    public static void main(String[] args) throws Exception {
        Configuration conf = HBaseConfiguration.create();
        ToolRunner.run((Configuration)conf, (Tool)new ExpiredMobFileCleaner(), (String[])args);
    }

    private void printUsage() {
        System.err.println("Usage:\n--------------------------\n" + ExpiredMobFileCleaner.class.getName() + " tableName familyName");
        System.err.println(" tableName        The table name");
        System.err.println(" familyName       The column family name");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressWarnings(value={"REC_CATCH_EXCEPTION"}, justification="Intentional")
    public int run(String[] args) throws Exception {
        if (args.length != 2) {
            this.printUsage();
            return 1;
        }
        String tableName = args[0];
        String familyName = args[1];
        TableName tn = TableName.valueOf(tableName);
        HBaseAdmin.available(this.getConf());
        Connection connection = ConnectionFactory.createConnection(this.getConf());
        Admin admin = connection.getAdmin();
        try {
            TableDescriptor htd = admin.getDescriptor(tn);
            ColumnFamilyDescriptor family = htd.getColumnFamily(Bytes.toBytes(familyName));
            if (family == null || !family.isMobEnabled()) {
                throw new IOException("Column family " + familyName + " is not a MOB column family");
            }
            if (family.getMinVersions() > 0) {
                throw new IOException("The minVersions of the column family is not 0, could not be handled by this cleaner");
            }
            this.cleanExpiredMobFiles(htd, family);
            int n = 0;
            return n;
        }
        finally {
            try {
                admin.close();
            }
            catch (IOException e) {
                LOG.error("Failed to close the HBaseAdmin.", (Throwable)e);
            }
            try {
                connection.close();
            }
            catch (IOException e) {
                LOG.error("Failed to close the connection.", (Throwable)e);
            }
        }
    }
}

