/*
 * Decompiled with CFR 0.152.
 */
package org.apache.groovy.ginq.provider.collection.runtime;

import groovy.lang.GroovyRuntimeException;
import groovy.lang.Tuple;
import groovy.lang.Tuple2;
import groovy.lang.Tuple3;
import groovy.transform.Internal;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.groovy.ginq.provider.collection.runtime.AsciiTableMaker;
import org.apache.groovy.ginq.provider.collection.runtime.ConcurrentObjectHolder;
import org.apache.groovy.ginq.provider.collection.runtime.Group;
import org.apache.groovy.ginq.provider.collection.runtime.Partition;
import org.apache.groovy.ginq.provider.collection.runtime.Queryable;
import org.apache.groovy.ginq.provider.collection.runtime.QueryableHelper;
import org.apache.groovy.ginq.provider.collection.runtime.Window;
import org.apache.groovy.ginq.provider.collection.runtime.WindowDefinition;
import org.apache.groovy.ginq.provider.collection.runtime.WindowImpl;
import org.apache.groovy.internal.util.Supplier;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.dgmimpl.NumberNumberMinus;
import org.codehaus.groovy.runtime.typehandling.NumberMath;

@Internal
class QueryableCollection<T>
implements Queryable<T>,
Serializable {
    private final Map<String, Queryable<Tuple2<?, Partition<Tuple2<T, Long>>>>> allPartitionCache = new ConcurrentHashMap(4);
    private final Map<PartitionCacheKey, Partition<Tuple2<T, Long>>> partitionCache = new ConcurrentHashMap<PartitionCacheKey, Partition<Tuple2<T, Long>>>(4);
    private final Map<SortedPartitionCacheKey<T>, Partition<Tuple2<T, Long>>> sortedPartitionCache = new ConcurrentHashMap<SortedPartitionCacheKey<T>, Partition<Tuple2<T, Long>>>(4);
    private Stream<T> sourceStream;
    private volatile Iterable<T> sourceIterable;
    private final ReadWriteLock rwl = new ReentrantReadWriteLock();
    private final Lock readLock = this.rwl.readLock();
    private final Lock writeLock = this.rwl.writeLock();
    private static final BigDecimal BD_TWO = BigDecimal.valueOf(2L);
    private static final String USE_WINDOW_FUNCTION = "useWindowFunction";
    private static final String PARALLEL = "parallel";
    private static final String TRUE_STR = "true";
    private static final String FALSE_STR = "false";
    private static final long serialVersionUID = -5067092453136522893L;

    QueryableCollection(Iterable<T> sourceIterable) {
        this.sourceIterable = sourceIterable;
    }

    QueryableCollection(Stream<T> sourceStream) {
        this.sourceStream = sourceStream;
    }

    public Iterator<T> iterator() {
        this.readLock.lock();
        try {
            if (null != this.sourceIterable) {
                Iterator<T> iterator = this.sourceIterable.iterator();
                return iterator;
            }
            Iterator iterator = this.sourceStream.iterator();
            return iterator;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public <U> Queryable<Tuple2<T, U>> innerJoin(Queryable<? extends U> queryable, BiPredicate<? super T, ? super U> joiner) {
        Stream stream = this.stream().flatMap(p -> {
            if (queryable instanceof QueryableCollection) {
                ((QueryableCollection)queryable).makeReusable();
            }
            return queryable.stream().filter(c -> joiner.test(p, c)).map(c -> Tuple.tuple((Object)p, (Object)c));
        });
        return Queryable.from(stream);
    }

    @Override
    public <U> Queryable<Tuple2<T, U>> innerHashJoin(Queryable<? extends U> queryable, Function<? super T, ?> fieldsExtractor1, Function<? super U, ?> fieldsExtractor2) {
        ConcurrentObjectHolder hashTableHolder = new ConcurrentObjectHolder(QueryableCollection.createHashTableSupplier(queryable, fieldsExtractor2));
        if (QueryableCollection.isParallel()) {
            hashTableHolder.getObject();
        }
        Stream stream = this.stream().flatMap(p -> {
            Map hashTable = (Map)hashTableHolder.getObject();
            return QueryableCollection.probeHashTable(hashTable, p, fieldsExtractor1);
        });
        return Queryable.from(stream);
    }

    private static <U> Supplier<Map<Integer, List<Candidate<U>>>> createHashTableSupplier(Queryable<? extends U> queryable, Function<? super U, ?> fieldsExtractor2) {
        return () -> {
            Function<Candidate, Integer> keyMapper = c -> QueryableCollection.hash(c.extracted);
            Function<Candidate, List> valueMapper = Bucket::singletonBucket;
            BinaryOperator mergeFunction = (oldBucket, newBucket) -> {
                oldBucket.addAll(newBucket);
                return oldBucket;
            };
            Collector<Candidate, ?, Map<Integer, List>> candidateMapCollector = QueryableCollection.isParallel() ? Collectors.toConcurrentMap(keyMapper, valueMapper, mergeFunction) : Collectors.toMap(keyMapper, valueMapper, mergeFunction);
            return queryable.stream().map(e -> new Candidate<Object>(e, fieldsExtractor2.apply((Object)e))).collect(candidateMapCollector);
        };
    }

    private static Integer hash(Object obj) {
        return Objects.hash(obj);
    }

    @Override
    public <U> Queryable<Tuple2<T, U>> leftJoin(Queryable<? extends U> queryable, BiPredicate<? super T, ? super U> joiner) {
        return QueryableCollection.outerJoin(this, queryable, joiner);
    }

    @Override
    public <U> Queryable<Tuple2<T, U>> leftHashJoin(Queryable<? extends U> queryable, Function<? super T, ?> fieldsExtractor1, Function<? super U, ?> fieldsExtractor2) {
        return QueryableCollection.outerHashJoin(this, queryable, fieldsExtractor1, fieldsExtractor2);
    }

    @Override
    public <U> Queryable<Tuple2<T, U>> rightJoin(Queryable<? extends U> queryable, BiPredicate<? super T, ? super U> joiner) {
        return QueryableCollection.outerJoin(queryable, this, (a, b) -> joiner.test(b, a)).select((e, q) -> Tuple.tuple((Object)e.getV2(), (Object)e.getV1()));
    }

    @Override
    public <U> Queryable<Tuple2<T, U>> rightHashJoin(Queryable<? extends U> queryable, Function<? super T, ?> fieldsExtractor1, Function<? super U, ?> fieldsExtractor2) {
        return QueryableCollection.outerHashJoin(queryable, this, fieldsExtractor2, fieldsExtractor1).select((e, q) -> Tuple.tuple((Object)e.getV2(), (Object)e.getV1()));
    }

    @Override
    public <U> Queryable<Tuple2<T, U>> fullJoin(Queryable<? extends U> queryable, BiPredicate<? super T, ? super U> joiner) {
        if (queryable instanceof QueryableCollection) {
            ((QueryableCollection)queryable).makeReusable();
        }
        this.makeReusable();
        Queryable<Tuple2<Tuple2<? super T, ? super U>, U>> lj = this.leftJoin(queryable, joiner);
        Queryable<Tuple2<? super T, ? super U>> rj = this.rightJoin(queryable, joiner);
        return lj.union(rj);
    }

    @Override
    public <U> Queryable<Tuple2<T, U>> fullHashJoin(Queryable<? extends U> queryable, Function<? super T, ?> fieldsExtractor1, Function<? super U, ?> fieldsExtractor2) {
        if (queryable instanceof QueryableCollection) {
            ((QueryableCollection)queryable).makeReusable();
        }
        this.makeReusable();
        Queryable<Tuple2<Tuple2<? super T, ? super U>, U>> lj = this.leftHashJoin(queryable, fieldsExtractor1, fieldsExtractor2);
        Queryable<Tuple2<? super T, ? super U>> rj = this.rightHashJoin(queryable, fieldsExtractor1, fieldsExtractor2);
        return lj.union(rj);
    }

    @Override
    public <U> Queryable<Tuple2<T, U>> crossJoin(Queryable<? extends U> queryable) {
        Stream stream = this.stream().flatMap(p -> {
            if (queryable instanceof QueryableCollection) {
                ((QueryableCollection)queryable).makeReusable();
            }
            return queryable.stream().map(c -> Tuple.tuple((Object)p, (Object)c));
        });
        return Queryable.from(stream);
    }

    @Override
    public Queryable<T> where(Predicate<? super T> filter) {
        Stream<? super T> stream = this.stream().filter(filter);
        return Queryable.from(stream);
    }

    @Override
    public Queryable<Tuple2<?, Queryable<T>>> groupBy(Function<? super T, ?> classifier, Predicate<? super Tuple2<?, Queryable<? extends T>>> having) {
        Collector groupingBy = QueryableCollection.isParallel() ? Collectors.groupingByConcurrent(classifier, Collectors.toList()) : Collectors.groupingBy(classifier, Collectors.toList());
        Stream<Tuple2> stream = ((Map)this.stream().collect(groupingBy)).entrySet().stream().filter(m -> null == having || having.test((Object)Tuple.tuple(m.getKey(), Queryable.from((Iterable)m.getValue())))).map(m -> Tuple.tuple(m.getKey(), Queryable.from((Iterable)m.getValue())));
        return Group.of(stream);
    }

    @Override
    public <U extends Comparable<? super U>> Queryable<T> orderBy(Queryable.Order<? super T, ? extends U> ... orders) {
        Comparator<? super T> comparator = QueryableCollection.makeComparator(orders);
        if (null == comparator) {
            return this;
        }
        return Queryable.from(this.stream().sorted(comparator));
    }

    protected static <T, U extends Comparable<? super U>> Comparator<T> makeComparator(List<? extends Queryable.Order<? super T, ? extends U>> orders) {
        return QueryableCollection.makeComparator(orders.toArray(Queryable.Order.EMPTY_ARRAY));
    }

    protected static <T, U extends Comparable<? super U>> Comparator<T> makeComparator(Queryable.Order<? super T, ? extends U> ... orders) {
        if (null == orders || 0 == orders.length) {
            return null;
        }
        Comparator<? super T> comparator = null;
        int n = orders.length;
        for (int i = 0; i < n; ++i) {
            Queryable.Order<T, U> order = orders[i];
            Comparator ascOrDesc = order.isAsc() ? Comparator.naturalOrder() : Comparator.reverseOrder();
            Comparator nullsLastOrFirst = order.isNullsLast() ? Comparator.nullsLast(ascOrDesc) : Comparator.nullsFirst(ascOrDesc);
            comparator = 0 == i ? Comparator.comparing(order.getKeyExtractor(), nullsLastOrFirst) : comparator.thenComparing(order.getKeyExtractor(), nullsLastOrFirst);
        }
        return comparator;
    }

    @Override
    public Queryable<T> limit(long offset, long size) {
        Stream<T> stream = this.stream().skip(offset).limit(size);
        return Queryable.from(stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <U> Queryable<U> select(BiFunction<? super T, ? super Queryable<? extends T>, ? extends U> mapper) {
        String originalParallel = (String)QueryableHelper.getVar(PARALLEL);
        QueryableHelper.setVar(PARALLEL, FALSE_STR);
        try {
            boolean useWindowFunction = TRUE_STR.equals(QueryableHelper.getVar(USE_WINDOW_FUNCTION));
            if (useWindowFunction) {
                this.makeReusable();
            }
            Stream<Object> stream = null;
            if (this instanceof Group) {
                this.makeReusable();
                if (0L == this.count()) {
                    stream = Stream.of(Tuple.tuple((Object)NULL, (Object)EMPTY_QUERYABLE)).map(t -> mapper.apply(t, this));
                }
            }
            if (null == stream) {
                stream = this.stream().map(t -> mapper.apply(t, this));
            }
            if (TRUE_STR.equals(originalParallel)) {
                stream = stream.collect(Collectors.toList()).parallelStream().map(u -> {
                    boolean interrupted = false;
                    try {
                        Object t = ((CompletableFuture)u).get();
                        return t;
                    }
                    catch (InterruptedException | ExecutionException ex) {
                        if (ex instanceof InterruptedException) {
                            interrupted = true;
                        }
                        throw new GroovyRuntimeException((Throwable)ex);
                    }
                    finally {
                        if (interrupted) {
                            Thread.currentThread().interrupt();
                        }
                    }
                });
            }
            Queryable queryable = Queryable.from(stream);
            return queryable;
        }
        finally {
            QueryableHelper.setVar(PARALLEL, originalParallel);
        }
    }

    @Override
    public Queryable<T> distinct() {
        Stream<T> stream = this.stream().distinct();
        return Queryable.from(stream);
    }

    @Override
    public Queryable<T> unionAll(Queryable<? extends T> queryable) {
        Stream<? extends T> stream = Stream.concat(this.stream(), queryable.stream());
        return Queryable.from(stream);
    }

    @Override
    public Queryable<T> intersect(Queryable<? extends T> queryable) {
        Stream<Object> stream = this.stream().filter(a -> {
            if (queryable instanceof QueryableCollection) {
                ((QueryableCollection)queryable).makeReusable();
            }
            return queryable.stream().anyMatch(b -> b.equals(a));
        }).distinct();
        return Queryable.from(stream);
    }

    @Override
    public Queryable<T> minus(Queryable<? extends T> queryable) {
        Stream<Object> stream = this.stream().filter(a -> {
            if (queryable instanceof QueryableCollection) {
                ((QueryableCollection)queryable).makeReusable();
            }
            return queryable.stream().noneMatch(b -> b.equals(a));
        }).distinct();
        return Queryable.from(stream);
    }

    @Override
    public Long count() {
        return this.agg(q -> q.stream().count());
    }

    @Override
    public <U> Long count(Function<? super T, ? extends U> mapper) {
        return this.agg(q -> q.stream().map(mapper).filter(Objects::nonNull).count());
    }

    @Override
    public BigDecimal sum(Function<? super T, ? extends Number> mapper) {
        return this.agg(q -> this.stream().map(e -> {
            Number n = (Number)mapper.apply(e);
            if (null == n) {
                return BigDecimal.ZERO;
            }
            return NumberMath.toBigDecimal((Number)n);
        }).reduce(BigDecimal.ZERO, BigDecimal::add));
    }

    @Override
    public BigDecimal avg(Function<? super T, ? extends Number> mapper) {
        Object[] result = this.agg(q -> q.stream().map(mapper).filter(Objects::nonNull).map(NumberMath::toBigDecimal).reduce(new Object[]{0L, BigDecimal.ZERO}, (r, e) -> {
            r[0] = (Long)r[0] + 1L;
            r[1] = ((BigDecimal)r[1]).add((BigDecimal)e);
            return r;
        }, (o1, o2) -> o1));
        return ((BigDecimal)result[1]).divide(NumberMath.toBigDecimal((Number)((Long)result[0])), 16, RoundingMode.HALF_UP);
    }

    @Override
    public <U extends Comparable<? super U>> U min(Function<? super T, ? extends U> mapper) {
        return (U)this.agg(q -> q.stream().map(mapper).filter(Objects::nonNull).min(Comparator.comparing(Function.identity())).orElse(null));
    }

    @Override
    public <U extends Comparable<? super U>> U max(Function<? super T, ? extends U> mapper) {
        return (U)this.agg(q -> q.stream().map(mapper).filter(Objects::nonNull).max(Comparator.comparing(Function.identity())).orElse(null));
    }

    @Override
    public <U> List<U> list(Function<? super T, ? extends U> mapper) {
        return this.agg(q -> q.stream().map(mapper).filter(Objects::nonNull).collect(Collectors.toList()));
    }

    @Override
    public BigDecimal median(Function<? super T, ? extends Number> mapper) {
        List sortedNumList = this.agg(q -> q.stream().map(mapper).filter(Objects::nonNull).map(NumberMath::toBigDecimal).sorted().collect(Collectors.toList()));
        int size = sortedNumList.size();
        if (0 == size) {
            return null;
        }
        int index = size / 2;
        BigDecimal num = (BigDecimal)sortedNumList.get(index);
        if (0 == size % 2) {
            return num.add((BigDecimal)sortedNumList.get(index - 1)).divide(BD_TWO);
        }
        return num;
    }

    @Override
    public BigDecimal stdev(Function<? super T, ? extends Number> mapper) {
        return this.sd(mapper, 0);
    }

    @Override
    public BigDecimal stdevp(Function<? super T, ? extends Number> mapper) {
        return this.sd(mapper, 1);
    }

    @Override
    public BigDecimal var(Function<? super T, ? extends Number> mapper) {
        return this.vr(mapper, 0);
    }

    @Override
    public BigDecimal varp(Function<? super T, ? extends Number> mapper) {
        return this.vr(mapper, 1);
    }

    private BigDecimal vr(Function<? super T, ? extends Number> mapper, int diff) {
        BigDecimal avg = this.avg(mapper);
        Object[] result = this.agg(q -> q.stream().map(mapper).filter(Objects::nonNull).map(e -> NumberMath.toBigDecimal((Number)NumberNumberMinus.minus((Number)e, (Number)avg)).pow(2)).reduce(new Object[]{0L, BigDecimal.ZERO}, (r, e) -> {
            r[0] = (Long)r[0] + 1L;
            r[1] = ((BigDecimal)r[1]).add((BigDecimal)e);
            return r;
        }, (o1, o2) -> o1));
        return ((BigDecimal)result[1]).divide(NumberMath.toBigDecimal((Number)((Long)result[0] - (long)diff)), 16, RoundingMode.HALF_UP);
    }

    private BigDecimal sd(Function<? super T, ? extends Number> mapper, int diff) {
        return NumberMath.toBigDecimal((Number)Math.sqrt(this.vr(mapper, diff).doubleValue()));
    }

    @Override
    public <U> U agg(Function<? super Queryable<? extends T>, ? extends U> mapper) {
        return mapper.apply(this);
    }

    private static <T, U> Queryable<Tuple2<T, U>> outerJoin(Queryable<? extends T> queryable1, Queryable<? extends U> queryable2, BiPredicate<? super T, ? super U> joiner) {
        Stream stream = queryable1.stream().flatMap(p -> {
            List joinResultList;
            if (queryable2 instanceof QueryableCollection) {
                ((QueryableCollection)queryable2).makeReusable();
            }
            return (joinResultList = queryable2.stream().filter(c -> joiner.test(p, c)).map(c -> Tuple.tuple((Object)p, (Object)c)).collect(Collectors.toList())).isEmpty() ? Stream.of(Tuple.tuple((Object)p, null)) : joinResultList.stream();
        });
        return Queryable.from(stream);
    }

    private static <T, U> Queryable<Tuple2<T, U>> outerHashJoin(Queryable<? extends T> queryable1, Queryable<? extends U> queryable2, Function<? super T, ?> fieldsExtractor1, Function<? super U, ?> fieldsExtractor2) {
        ConcurrentObjectHolder hashTableHolder = new ConcurrentObjectHolder(QueryableCollection.createHashTableSupplier(queryable2, fieldsExtractor2));
        if (QueryableCollection.isParallel()) {
            hashTableHolder.getObject();
        }
        Stream stream = queryable1.stream().flatMap(p -> {
            Map hashTable = (Map)hashTableHolder.getObject();
            List joinResultList = QueryableCollection.probeHashTable(hashTable, p, fieldsExtractor1).collect(Collectors.toList());
            return joinResultList.isEmpty() ? Stream.of(Tuple.tuple((Object)p, null)) : joinResultList.stream();
        });
        return Queryable.from(stream);
    }

    private static <T, U> Stream<Tuple2<T, U>> probeHashTable(Map<Integer, List<Candidate<U>>> hashTable, T p, Function<? super T, ?> fieldsExtractor1) {
        Object otherFields = fieldsExtractor1.apply(p);
        Integer h = QueryableCollection.hash(otherFields);
        List<Candidate<U>> candidateList = hashTable.get(h);
        if (null == candidateList) {
            return Stream.empty();
        }
        Stream stream = candidateList.stream();
        if (QueryableCollection.isParallel()) {
            stream = (Stream)stream.parallel();
        }
        return stream.filter(c -> Objects.equals(otherFields, c.extracted)).map(c -> Tuple.tuple((Object)p, c.original));
    }

    @Override
    public List<T> toList() {
        this.writeLock.lock();
        try {
            if (this.sourceIterable instanceof List) {
                List list = (List)this.sourceIterable;
                return list;
            }
            List result = this.stream().collect(Collectors.toList());
            this.sourceIterable = result;
            List list = result;
            return list;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public long size() {
        return this.stream().count();
    }

    @Override
    public Stream<T> stream() {
        this.writeLock.lock();
        try {
            if (this.isReusable()) {
                this.sourceStream = QueryableCollection.toStream(this.sourceIterable);
            }
            if (!this.sourceStream.isParallel() && QueryableCollection.isParallel()) {
                this.sourceStream = (Stream)this.sourceStream.parallel();
            }
            Stream<T> stream = this.sourceStream;
            return stream;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public <U extends Comparable<? super U>> Window<T> over(Tuple2<T, Long> currentRecord, WindowDefinition<T, U> windowDefinition) {
        Tuple3 idTuple = (Tuple3)windowDefinition.getId();
        String partitionId = (String)idTuple.getV1();
        Partition partition = this.partitionCache.computeIfAbsent(new PartitionCacheKey(windowDefinition.partitionBy().apply(currentRecord.getV1()), partitionId), partitionCacheKey -> Queryable.from(Collections.singletonList(currentRecord)).innerHashJoin(this.allPartitionCache.computeIfAbsent(partitionId, pid -> {
            long[] rn = new long[]{0L};
            List listWithIndex = this.toList().stream().map(e -> {
                long l = rn[0];
                rn[0] = l + 1L;
                return Tuple.tuple((Object)e, (Object)l);
            }).collect(Collectors.toList());
            Queryable<Tuple2> q = Queryable.from(listWithIndex).groupBy(windowDefinition.partitionBy().compose(Tuple2::getV1)).select((e, x) -> Tuple.tuple((Object)e.getV1(), Partition.of(((Queryable)e.getV2()).toList())));
            if (q instanceof QueryableCollection) {
                ((QueryableCollection)q).makeReusable();
            }
            return q;
        }), a -> partitionCacheKey.partitionKey, Tuple2::getV1).select((e, q) -> (Partition)((Tuple2)e.getV2()).getV2()).stream().findFirst().orElse(Partition.emptyPartition()));
        String orderId = (String)idTuple.getV2();
        SortedPartitionCacheKey sortedPartitionCacheKey = new SortedPartitionCacheKey(partition, orderId);
        Partition sortedPartition = this.sortedPartitionCache.computeIfAbsent(sortedPartitionCacheKey, sortedPartitionId -> Partition.of(partition.orderBy(WindowImpl.composeOrders(windowDefinition)).toList()));
        return Window.of(currentRecord, sortedPartition, windowDefinition);
    }

    private static <T> Stream<T> toStream(Iterable<T> sourceIterable) {
        return StreamSupport.stream(sourceIterable.spliterator(), QueryableCollection.isParallel());
    }

    private static boolean isParallel() {
        return QueryableHelper.isParallel();
    }

    private boolean isReusable() {
        this.readLock.lock();
        try {
            boolean bl = null != this.sourceIterable;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private void makeReusable() {
        if (null != this.sourceIterable) {
            return;
        }
        this.writeLock.lock();
        try {
            if (null != this.sourceIterable) {
                return;
            }
            this.sourceIterable = this.sourceStream.collect(Collectors.toList());
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public Object asType(Class<?> clazz) {
        if (Queryable.class == clazz || QueryableCollection.class == clazz) {
            return this;
        }
        if (List.class == clazz || Collection.class == clazz || Iterable.class == clazz) {
            return this.toList();
        }
        if (ArrayList.class == clazz) {
            List<T> list = this.toList();
            if (list instanceof ArrayList) {
                return list;
            }
            return new ArrayList<T>(list);
        }
        if (LinkedList.class == clazz || Deque.class == clazz || Queue.class == clazz) {
            List<T> list = this.toList();
            if (list instanceof LinkedList) {
                return list;
            }
            return new LinkedList<T>(list);
        }
        if (clazz.isArray()) {
            return DefaultGroovyMethods.asType(this.toList(), clazz);
        }
        if (Set.class == clazz || LinkedHashSet.class == clazz) {
            return new LinkedHashSet<T>(this.toList());
        }
        if (HashSet.class == clazz) {
            return new HashSet<T>(this.toList());
        }
        if (TreeSet.class == clazz) {
            return new TreeSet<T>(this.toList());
        }
        if (Stream.class == clazz) {
            return this.stream();
        }
        if (Iterator.class == clazz) {
            return this.iterator();
        }
        return DefaultGroovyMethods.asType((Object)this, clazz);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof QueryableCollection)) {
            return false;
        }
        QueryableCollection that = (QueryableCollection)o;
        return this.toList().equals(that.toList());
    }

    public int hashCode() {
        return Objects.hash(this.toList());
    }

    public String toString() {
        return AsciiTableMaker.makeAsciiTable(this);
    }

    private static class PartitionCacheKey {
        private final Object partitionKey;
        private final String partitionId;

        PartitionCacheKey(Object partitionKey, String partitionId) {
            this.partitionKey = partitionKey;
            this.partitionId = partitionId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PartitionCacheKey)) {
                return false;
            }
            PartitionCacheKey that = (PartitionCacheKey)o;
            return this.partitionKey.equals(that.partitionKey) && this.partitionId.equals(that.partitionId);
        }

        public int hashCode() {
            return Objects.hash(this.partitionKey, this.partitionId);
        }
    }

    private static class SortedPartitionCacheKey<T> {
        private final Partition<Tuple2<T, Long>> partition;
        private final String orderId;

        SortedPartitionCacheKey(Partition<Tuple2<T, Long>> partition, String orderId) {
            this.partition = partition;
            this.orderId = orderId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SortedPartitionCacheKey)) {
                return false;
            }
            SortedPartitionCacheKey that = (SortedPartitionCacheKey)o;
            return this.partition == that.partition && this.orderId.equals(that.orderId);
        }

        public int hashCode() {
            return Objects.hash(this.partition.size(), this.orderId);
        }
    }

    private static final class Candidate<U> {
        private final U original;
        private final Object extracted;

        private Candidate(U original, Object extracted) {
            this.original = original;
            this.extracted = extracted;
        }
    }

    private static final class Bucket<E>
    extends ArrayList<E> {
        private static final long serialVersionUID = 2813676753531316403L;

        Bucket(int initialCapacity) {
            super(initialCapacity);
        }

        static <E> Bucket<E> singletonBucket(E o) {
            Bucket<E> bucket = new Bucket<E>(1);
            bucket.add(o);
            return bucket;
        }
    }
}

