/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform.sc.transformers;

import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.EmptyStatement;
import org.codehaus.groovy.classgen.AsmClassGenerator;
import org.codehaus.groovy.classgen.asm.MopWriter;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.transform.sc.transformers.CompareIdentityExpression;
import org.codehaus.groovy.transform.sc.transformers.StaticCompilationTransformer;
import org.codehaus.groovy.transform.stc.ExtensionMethodNode;
import org.codehaus.groovy.transform.stc.StaticTypesMarker;

class MethodCallExpressionTransformer {
    private final StaticCompilationTransformer scTransformer;

    MethodCallExpressionTransformer(StaticCompilationTransformer scTransformer) {
        this.scTransformer = scTransformer;
    }

    Expression transformMethodCallExpression(MethodCallExpression mce) {
        Expression arguments = mce.getArguments();
        if (!mce.isSafe() && !mce.isSpreadSafe() && MethodCallExpressionTransformer.isIsExtension(mce.getMethodTarget()) && AsmClassGenerator.argumentSize(arguments) == 1) {
            Expression lhs = this.scTransformer.transform(mce.getObjectExpression());
            Expression rhs = this.scTransformer.transform(arguments instanceof TupleExpression ? ((TupleExpression)arguments).getExpression(0) : arguments);
            CompareIdentityExpression cmp = new CompareIdentityExpression(lhs, rhs);
            cmp.setSourcePosition(mce);
            return cmp;
        }
        Object superCallReceiver = mce.getNodeMetaData((Object)StaticTypesMarker.SUPER_MOP_METHOD_REQUIRED);
        if (superCallReceiver instanceof ClassNode) {
            return this.transformMethodCallExpression(MethodCallExpressionTransformer.transformToMopSuperCall((ClassNode)superCallReceiver, mce));
        }
        Expression callable = (Expression)mce.putNodeMetaData("callable property", null);
        if (callable != null) {
            MethodCallExpression callableCall = new MethodCallExpression(this.scTransformer.transform(callable), "call", this.scTransformer.transform(arguments));
            callableCall.setImplicitThis(false);
            callableCall.setMethodTarget((MethodNode)mce.getNodeMetaData((Object)StaticTypesMarker.DIRECT_METHOD_CALL_TARGET));
            callableCall.setSourcePosition(mce);
            callableCall.copyNodeMetaData(mce);
            return callableCall;
        }
        return this.scTransformer.superTransform(mce);
    }

    private static boolean isIsExtension(MethodNode node) {
        return node instanceof ExtensionMethodNode && "is".equals(node.getName()) && node.getParameters().length == 1 && DefaultGroovyMethods.class.getName().equals(((ExtensionMethodNode)node).getExtensionMethodNode().getDeclaringClass().getName());
    }

    private static MethodCallExpression transformToMopSuperCall(ClassNode superType, MethodCallExpression expr) {
        MethodNode mn = (MethodNode)expr.getNodeMetaData((Object)StaticTypesMarker.DIRECT_METHOD_CALL_TARGET);
        String mopName = MopWriter.getMopMethodName(mn, false);
        MethodNode direct = new MethodNode(mopName, 4097, mn.getReturnType(), mn.getParameters(), mn.getExceptions(), EmptyStatement.INSTANCE);
        direct.setDeclaringClass(superType);
        MethodCallExpression result = new MethodCallExpression((Expression)new VariableExpression("this"), mopName, expr.getArguments());
        result.setImplicitThis(true);
        result.setSpreadSafe(false);
        result.setSafe(false);
        result.setSourcePosition(expr);
        result.setMethodTarget(direct);
        return result;
    }
}

