/*
 * Decompiled with CFR 0.152.
 */
package org.apache.groovy.contracts.common.spi;

import java.util.HashMap;
import java.util.Map;
import org.apache.groovy.contracts.domain.Contract;
import org.apache.groovy.contracts.util.Validate;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.io.ReaderSource;
import org.codehaus.groovy.control.messages.Message;
import org.codehaus.groovy.control.messages.SyntaxErrorMessage;
import org.codehaus.groovy.syntax.SyntaxException;

public class ProcessingContextInformation {
    private final Contract contract;
    private final SourceUnit sourceUnit;
    private final ReaderSource source;
    private boolean constructorAssertionsEnabled = true;
    private boolean preconditionsEnabled = true;
    private boolean postconditionsEnabled = true;
    private boolean classInvariantsEnabled = true;
    private final Map<String, Object> extra = new HashMap<String, Object>();

    public ProcessingContextInformation(ClassNode classNode, SourceUnit sourceUnit, ReaderSource source) {
        Validate.notNull(classNode);
        this.contract = new Contract(classNode);
        this.sourceUnit = sourceUnit;
        this.source = source;
    }

    public void setConstructorAssertionsEnabled(boolean other) {
        this.constructorAssertionsEnabled = other;
    }

    public boolean isConstructorAssertionsEnabled() {
        return this.constructorAssertionsEnabled;
    }

    public boolean isPreconditionsEnabled() {
        return this.preconditionsEnabled;
    }

    public boolean isPostconditionsEnabled() {
        return this.postconditionsEnabled;
    }

    public boolean isClassInvariantsEnabled() {
        return this.classInvariantsEnabled;
    }

    public Contract contract() {
        return this.contract;
    }

    public ReaderSource readerSource() {
        return this.source;
    }

    public SourceUnit sourceUnit() {
        return this.sourceUnit;
    }

    public void put(String key, Object value) {
        Validate.notNull(key);
        this.extra.put(key, value);
    }

    public Object get(String key) {
        Validate.notNull(key);
        return this.extra.get(key);
    }

    public void addError(String msg, ASTNode expr) {
        int line = expr.getLineNumber();
        int col = expr.getColumnNumber();
        SourceUnit source = this.sourceUnit();
        source.getErrorCollector().addErrorAndContinue((Message)new SyntaxErrorMessage(new SyntaxException(msg + "\n", line, col), source));
    }
}

