/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.factories;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.factories.Factory;
import org.apache.flink.table.types.DataType;

@PublicEvolving
public interface DynamicTableFactory
extends Factory {
    default public Set<ConfigOption<?>> forwardOptions() {
        return Collections.emptySet();
    }

    @PublicEvolving
    public static interface Context {
        public ObjectIdentifier getObjectIdentifier();

        public ResolvedCatalogTable getCatalogTable();

        default public Map<String, String> getEnrichmentOptions() {
            return Collections.emptyMap();
        }

        public ReadableConfig getConfiguration();

        public ClassLoader getClassLoader();

        public boolean isTemporary();

        default public DataType getPhysicalRowDataType() {
            return this.getCatalogTable().getResolvedSchema().toPhysicalRowDataType();
        }

        default public int[] getPrimaryKeyIndexes() {
            return this.getCatalogTable().getResolvedSchema().getPrimaryKeyIndexes();
        }
    }
}

