/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.join.stream.bundle;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.util.RowDataUtil;
import org.apache.flink.table.runtime.operators.join.stream.bundle.BufferBundle;
import org.apache.flink.types.RowKind;

public class InputSideHasNoUniqueKeyBundle
extends BufferBundle<Map<Integer, List<RowData>>> {
    @Override
    public int addRecord(RowData joinKey, @Nullable RowData uniqueKey, RowData record) {
        this.bundle.computeIfAbsent(joinKey, k -> new HashMap());
        RowKind rowKind = record.getRowKind();
        record.setRowKind(RowKind.INSERT);
        int hashKey = record.hashCode();
        record.setRowKind(rowKind);
        if (!this.foldRecord(joinKey, hashKey, record)) {
            ++this.actualSize;
            this.bundle.computeIfAbsent(joinKey, k -> new HashMap()).computeIfAbsent(hashKey, k -> new ArrayList()).add(record);
        }
        return ++this.count;
    }

    @Override
    public Map<RowData, List<RowData>> getRecords() throws Exception {
        HashMap<RowData, List<RowData>> result = new HashMap<RowData, List<RowData>>();
        for (Map.Entry entry : this.bundle.entrySet()) {
            result.computeIfAbsent((RowData)entry.getKey(), k -> new ArrayList());
            for (List list : ((Map)entry.getValue()).values()) {
                ((List)result.get(entry.getKey())).addAll(list);
            }
        }
        return result;
    }

    @Override
    public Map<RowData, List<RowData>> getRecordsWithJoinKey(RowData joinKey) {
        throw new UnsupportedOperationException("JoinKeyContainsUniqueKeyBundle do not support getRecordsWithJoinKey() function.");
    }

    private boolean foldRecord(RowData joinKey, int hashKey, RowData record) {
        List list = ((Map)this.bundle.get(joinKey)).computeIfAbsent(hashKey, k -> new ArrayList());
        ListIterator iterator = list.listIterator(((List)((Map)this.bundle.get(joinKey)).get(hashKey)).size());
        while (iterator.hasPrevious()) {
            RowData rec = (RowData)iterator.previous();
            if ((!RowDataUtil.isAccumulateMsg(record) || !RowDataUtil.isRetractMsg(rec)) && (!RowDataUtil.isRetractMsg(record) || !RowDataUtil.isAccumulateMsg(rec))) continue;
            RowKind recRowKind = rec.getRowKind();
            RowKind recordRowKind = record.getRowKind();
            rec.setRowKind(RowKind.INSERT);
            record.setRowKind(RowKind.INSERT);
            if (record.equals(rec)) {
                iterator.remove();
                --this.actualSize;
                if (list.isEmpty()) {
                    ((Map)this.bundle.get(joinKey)).remove(hashKey);
                    if (((Map)this.bundle.get(joinKey)).isEmpty()) {
                        this.bundle.remove(joinKey);
                    }
                }
                return true;
            }
            rec.setRowKind(recRowKind);
            record.setRowKind(recordRowKind);
        }
        return false;
    }
}

