/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.table.stream;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.state.OperatorStateStore;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.ListSerializer;
import org.apache.flink.api.common.typeutils.base.LongSerializer;
import org.apache.flink.api.common.typeutils.base.MapSerializer;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.connector.file.table.stream.PartitionCommitPredicate;
import org.apache.flink.connector.file.table.stream.PartitionCommitTrigger;
import org.apache.flink.util.StringUtils;

@Internal
public class PartitionTimeCommitTrigger
implements PartitionCommitTrigger {
    private static final ListStateDescriptor<List<String>> PENDING_PARTITIONS_STATE_DESC = new ListStateDescriptor("pending-partitions", (TypeSerializer)new ListSerializer((TypeSerializer)StringSerializer.INSTANCE));
    private static final ListStateDescriptor<Map<Long, Long>> WATERMARKS_STATE_DESC = new ListStateDescriptor("checkpoint-id-to-watermark", (TypeSerializer)new MapSerializer((TypeSerializer)LongSerializer.INSTANCE, (TypeSerializer)LongSerializer.INSTANCE));
    private final ListState<List<String>> pendingPartitionsState;
    private final Set<String> pendingPartitions;
    private final ListState<Map<Long, Long>> watermarksState;
    private final TreeMap<Long, Long> watermarks;
    private final PartitionCommitPredicate partitionCommitPredicate;

    public PartitionTimeCommitTrigger(boolean isRestored, OperatorStateStore stateStore, PartitionCommitPredicate partitionCommitPredicate) throws Exception {
        this.pendingPartitionsState = stateStore.getListState(PENDING_PARTITIONS_STATE_DESC);
        this.pendingPartitions = new HashSet<String>();
        if (isRestored) {
            this.pendingPartitions.addAll((Collection)((Iterable)this.pendingPartitionsState.get()).iterator().next());
        }
        this.partitionCommitPredicate = partitionCommitPredicate;
        this.watermarksState = stateStore.getListState(WATERMARKS_STATE_DESC);
        this.watermarks = new TreeMap();
        if (isRestored) {
            this.watermarks.putAll((Map)((Iterable)this.watermarksState.get()).iterator().next());
        }
    }

    @Override
    public void addPartition(String partition) {
        if (!StringUtils.isNullOrWhitespaceOnly((String)partition)) {
            this.pendingPartitions.add(partition);
        }
    }

    @Override
    public List<String> committablePartitions(long checkpointId) {
        if (!this.watermarks.containsKey(checkpointId)) {
            throw new IllegalArgumentException(String.format("Checkpoint(%d) has not been snapshot. The watermark information is: %s.", checkpointId, this.watermarks));
        }
        long watermark = this.watermarks.get(checkpointId);
        this.watermarks.headMap(checkpointId, true).clear();
        ArrayList<String> needCommit = new ArrayList<String>();
        Iterator<String> iter = this.pendingPartitions.iterator();
        while (iter.hasNext()) {
            String partition = iter.next();
            PartitionCommitPredicate.PredicateContext predicateContext = this.createPredicateContext(partition, watermark);
            if (!this.partitionCommitPredicate.isPartitionCommittable(predicateContext)) continue;
            needCommit.add(partition);
            iter.remove();
        }
        return needCommit;
    }

    private PartitionCommitPredicate.PredicateContext createPredicateContext(final String partition, final long watermark) {
        return new PartitionCommitPredicate.PredicateContext(){

            @Override
            public String partition() {
                return partition;
            }

            @Override
            public long createProcTime() {
                throw new UnsupportedOperationException("Method createProcTime isn't supported in PartitionTimeCommitTrigger.");
            }

            @Override
            public long currentProcTime() {
                throw new UnsupportedOperationException("Method currentProcTime isn't supported in PartitionTimeCommitTrigger.");
            }

            @Override
            public long currentWatermark() {
                return watermark;
            }
        };
    }

    @Override
    public void snapshotState(long checkpointId, long watermark) throws Exception {
        this.pendingPartitionsState.update(Collections.singletonList(new ArrayList<String>(this.pendingPartitions)));
        this.watermarks.put(checkpointId, watermark);
        this.watermarksState.update(Collections.singletonList(new HashMap<Long, Long>(this.watermarks)));
    }

    @Override
    public List<String> endInput() {
        ArrayList<String> partitions = new ArrayList<String>(this.pendingPartitions);
        this.pendingPartitions.clear();
        return partitions;
    }
}

