/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.aggregate.window.processors;

import java.time.ZoneId;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.LongSerializer;
import org.apache.flink.streaming.api.operators.InternalTimerService;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.generated.GeneratedNamespaceAggsHandleFunction;
import org.apache.flink.table.runtime.operators.aggregate.window.buffers.WindowBuffer;
import org.apache.flink.table.runtime.operators.aggregate.window.processors.AbstractSyncStateWindowAggProcessor;
import org.apache.flink.table.runtime.operators.window.tvf.common.SyncStateWindowProcessor;
import org.apache.flink.table.runtime.operators.window.tvf.common.WindowTimerService;
import org.apache.flink.table.runtime.operators.window.tvf.slicing.SliceAssigner;
import org.apache.flink.table.runtime.operators.window.tvf.slicing.SlicingSyncStateWindowProcessor;
import org.apache.flink.table.runtime.operators.window.tvf.slicing.SlicingWindowTimerServiceImpl;
import org.apache.flink.table.runtime.util.TimeWindowUtil;

public abstract class AbstractSliceSyncStateWindowAggProcessor
extends AbstractSyncStateWindowAggProcessor<Long>
implements SlicingSyncStateWindowProcessor<Long> {
    protected final WindowBuffer.Factory windowBufferFactory;
    protected final SliceAssigner sliceAssigner;
    protected final long windowInterval;
    private transient long nextTriggerProgress;
    protected transient WindowBuffer windowBuffer;

    public AbstractSliceSyncStateWindowAggProcessor(GeneratedNamespaceAggsHandleFunction<Long> genAggsHandler, WindowBuffer.Factory bufferFactory, SliceAssigner sliceAssigner, TypeSerializer<RowData> accSerializer, int indexOfCountStar, ZoneId shiftTimeZone) {
        super(genAggsHandler, sliceAssigner, accSerializer, sliceAssigner.isEventTime(), indexOfCountStar, shiftTimeZone);
        this.windowBufferFactory = bufferFactory;
        this.sliceAssigner = sliceAssigner;
        this.windowInterval = sliceAssigner.getSliceEndInterval();
    }

    @Override
    public void open(SyncStateWindowProcessor.SyncStateContext<Long> context) throws Exception {
        super.open(context);
        this.windowBuffer = this.windowBufferFactory.create(((SyncStateWindowProcessor.SyncStateContext)this.ctx).getOperatorOwner(), ((SyncStateWindowProcessor.SyncStateContext)this.ctx).getMemoryManager(), ((SyncStateWindowProcessor.SyncStateContext)this.ctx).getMemorySize(), ((SyncStateWindowProcessor.SyncStateContext)this.ctx).getRuntimeContext(), this.windowTimerService, ((SyncStateWindowProcessor.SyncStateContext)this.ctx).getKeyedStateBackend(), this.windowState, this.isEventTime, this.shiftTimeZone);
        this.nextTriggerProgress = Long.MIN_VALUE;
    }

    @Override
    protected WindowTimerService<Long> getWindowTimerService() {
        return new SlicingWindowTimerServiceImpl((InternalTimerService<Long>)((SyncStateWindowProcessor.SyncStateContext)this.ctx).getTimerService(), this.shiftTimeZone);
    }

    @Override
    public boolean processElement(RowData key, RowData element) throws Exception {
        long sliceEnd = this.sliceAssigner.assignSliceEnd(element, this.clockService);
        if (!this.isEventTime) {
            this.windowTimerService.registerProcessingTimeWindowTimer(sliceEnd);
        }
        if (this.isEventTime && TimeWindowUtil.isWindowFired(sliceEnd, this.currentProgress, this.shiftTimeZone)) {
            long lastWindowEnd = this.sliceAssigner.getLastWindowEnd(sliceEnd);
            if (TimeWindowUtil.isWindowFired(lastWindowEnd, this.currentProgress, this.shiftTimeZone)) {
                return true;
            }
            this.windowBuffer.addElement(key, this.sliceStateMergeTarget(sliceEnd), element);
            long unfiredFirstWindow = sliceEnd;
            while (TimeWindowUtil.isWindowFired(unfiredFirstWindow, this.currentProgress, this.shiftTimeZone)) {
                unfiredFirstWindow += this.windowInterval;
            }
            this.windowTimerService.registerEventTimeWindowTimer(unfiredFirstWindow);
            return false;
        }
        this.windowBuffer.addElement(key, sliceEnd, element);
        return false;
    }

    protected abstract long sliceStateMergeTarget(long var1) throws Exception;

    @Override
    public void advanceProgress(long progress) throws Exception {
        if (progress > this.currentProgress) {
            this.currentProgress = progress;
            if (this.currentProgress >= this.nextTriggerProgress) {
                this.windowBuffer.advanceProgress(this.currentProgress);
                this.nextTriggerProgress = TimeWindowUtil.getNextTriggerWatermark(this.currentProgress, this.windowInterval, this.shiftTimeZone, this.useDayLightSaving);
            }
        }
    }

    @Override
    public void prepareCheckpoint() throws Exception {
        this.windowBuffer.flush();
    }

    @Override
    public void clearWindow(long timerTimestamp, Long windowEnd) throws Exception {
        Iterable<Long> expires = this.sliceAssigner.expiredSlices(windowEnd);
        for (Long slice : expires) {
            this.windowState.clear(slice);
            this.aggregator.cleanup(slice);
        }
    }

    @Override
    public void close() throws Exception {
        super.close();
        if (this.windowBuffer != null) {
            this.windowBuffer.close();
        }
    }

    @Override
    public TypeSerializer<Long> createWindowSerializer() {
        return LongSerializer.INSTANCE;
    }
}

