/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.utils;

import org.apache.calcite.sql.SqlIntervalLiteral;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.flink.annotation.Internal;
import org.apache.flink.sql.parser.ddl.SqlRefreshMode;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.CatalogMaterializedTable;
import org.apache.flink.table.catalog.IntervalFreshness;

@Internal
public class MaterializedTableUtils {
    public static IntervalFreshness getMaterializedTableFreshness(SqlIntervalLiteral sqlIntervalLiteral) {
        if (sqlIntervalLiteral.signum() < 0) {
            throw new ValidationException("Materialized table freshness doesn't support negative value.");
        }
        if (sqlIntervalLiteral.getTypeName().getFamily() != SqlTypeFamily.INTERVAL_DAY_TIME) {
            throw new ValidationException("Materialized table freshness only support SECOND, MINUTE, HOUR, DAY as the time unit.");
        }
        SqlIntervalLiteral.IntervalValue intervalValue = sqlIntervalLiteral.getValueAs(SqlIntervalLiteral.IntervalValue.class);
        String interval = intervalValue.getIntervalLiteral();
        switch (intervalValue.getIntervalQualifier().typeName()) {
            case INTERVAL_DAY: {
                return IntervalFreshness.ofDay((String)interval);
            }
            case INTERVAL_HOUR: {
                return IntervalFreshness.ofHour((String)interval);
            }
            case INTERVAL_MINUTE: {
                return IntervalFreshness.ofMinute((String)interval);
            }
            case INTERVAL_SECOND: {
                return IntervalFreshness.ofSecond((String)interval);
            }
        }
        throw new ValidationException("Materialized table freshness only support SECOND, MINUTE, HOUR, DAY as the time unit.");
    }

    public static CatalogMaterializedTable.LogicalRefreshMode deriveLogicalRefreshMode(SqlRefreshMode sqlRefreshMode) {
        if (sqlRefreshMode == null) {
            return CatalogMaterializedTable.LogicalRefreshMode.AUTOMATIC;
        }
        switch (sqlRefreshMode) {
            case FULL: {
                return CatalogMaterializedTable.LogicalRefreshMode.FULL;
            }
            case CONTINUOUS: {
                return CatalogMaterializedTable.LogicalRefreshMode.CONTINUOUS;
            }
        }
        throw new ValidationException(String.format("Unsupported logical refresh mode: %s.", new Object[]{sqlRefreshMode}));
    }

    public static CatalogMaterializedTable.RefreshMode fromSqltoRefreshMode(SqlRefreshMode sqlRefreshMode) {
        switch (sqlRefreshMode) {
            case FULL: {
                return CatalogMaterializedTable.RefreshMode.FULL;
            }
            case CONTINUOUS: {
                return CatalogMaterializedTable.RefreshMode.CONTINUOUS;
            }
        }
        throw new IllegalArgumentException("Unknown refresh mode: " + String.valueOf((Object)sqlRefreshMode));
    }
}

