/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.utils;

import java.util.Optional;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalRel;
import org.apache.flink.table.planner.plan.trait.DuplicateChanges;
import org.apache.flink.table.planner.plan.trait.DuplicateChangesTrait;
import org.apache.flink.table.planner.plan.trait.DuplicateChangesTraitDef;

public class DuplicateChangesUtils {
    private DuplicateChangesUtils() {
    }

    public static Optional<DuplicateChanges> getDuplicateChanges(StreamPhysicalRel rel) {
        Optional<DuplicateChangesTrait> duplicateChangesTraitOp = Optional.ofNullable(rel.getTraitSet().getTrait(DuplicateChangesTraitDef.INSTANCE));
        return duplicateChangesTraitOp.stream().map(DuplicateChangesTrait::getDuplicateChanges).findFirst();
    }

    public static DuplicateChanges mergeDuplicateChanges(DuplicateChanges duplicateChanges1, DuplicateChanges duplicateChanges2) {
        if (duplicateChanges1 == DuplicateChanges.NONE || duplicateChanges2 == DuplicateChanges.NONE) {
            return duplicateChanges1 == DuplicateChanges.NONE ? duplicateChanges2 : duplicateChanges1;
        }
        if (duplicateChanges1 == DuplicateChanges.DISALLOW || duplicateChanges2 == DuplicateChanges.DISALLOW) {
            return DuplicateChanges.DISALLOW;
        }
        return DuplicateChanges.ALLOW;
    }
}

