/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.hep.HepRelVertex;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelVisitor;
import org.apache.calcite.rel.core.Calc;
import org.apache.calcite.rel.core.JoinInfo;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.mapping.IntPair;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.calcite.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import org.apache.flink.shaded.guava33.com.google.common.collect.Sets;
import org.apache.flink.table.catalog.Index;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.connector.source.LookupTableSource;
import org.apache.flink.table.functions.AsyncTableFunction;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.plan.abilities.source.FilterPushDownSpec;
import org.apache.flink.table.planner.plan.abilities.source.PartitionPushDownSpec;
import org.apache.flink.table.planner.plan.abilities.source.ProjectPushDownSpec;
import org.apache.flink.table.planner.plan.abilities.source.ReadingMetadataSpec;
import org.apache.flink.table.planner.plan.abilities.source.SourceAbilitySpec;
import org.apache.flink.table.planner.plan.metadata.FlinkRelMetadataQuery;
import org.apache.flink.table.planner.plan.nodes.exec.spec.DeltaJoinSpec;
import org.apache.flink.table.planner.plan.nodes.exec.spec.JoinSpec;
import org.apache.flink.table.planner.plan.nodes.exec.spec.TemporalTableSourceSpec;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalCalc;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalDropUpdateBefore;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalExchange;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalIntermediateTableScan;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalJoin;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalRel;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalTableSourceScan;
import org.apache.flink.table.planner.plan.schema.IntermediateRelTable;
import org.apache.flink.table.planner.plan.schema.TableSourceTable;
import org.apache.flink.table.planner.plan.trait.DuplicateChanges;
import org.apache.flink.table.planner.plan.utils.ChangelogPlanUtils;
import org.apache.flink.table.planner.plan.utils.DuplicateChangesUtils;
import org.apache.flink.table.planner.plan.utils.FlinkRexUtil;
import org.apache.flink.table.planner.plan.utils.FunctionCallUtil;
import org.apache.flink.table.planner.plan.utils.JoinTypeUtil;
import org.apache.flink.table.planner.plan.utils.JoinUtil;
import org.apache.flink.table.planner.plan.utils.LookupJoinUtil;
import org.apache.flink.table.planner.plan.utils.RexNodeExtractor;
import org.apache.flink.table.planner.plan.utils.TemporalJoinUtil;
import org.apache.flink.table.planner.utils.JavaScalaConversionUtil;
import org.apache.flink.table.runtime.functions.table.lookup.CachingAsyncLookupFunction;
import org.apache.flink.table.runtime.operators.join.FlinkJoinType;
import org.apache.flink.table.runtime.operators.join.lookup.RetryableAsyncLookupFunctionDelegator;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.Preconditions;
import scala.Option;

public class DeltaJoinUtil {
    private static final Set<Class<?>> ALL_SUPPORTED_DELTA_JOIN_UPSTREAM_NODES = Sets.newHashSet((Object[])new Class[]{StreamPhysicalTableSourceScan.class, StreamPhysicalExchange.class, StreamPhysicalDropUpdateBefore.class, StreamPhysicalCalc.class});
    private static final Set<Class<?>> ALL_SUPPORTED_ABILITY_SPEC_IN_SOURCE = Sets.newHashSet((Object[])new Class[]{FilterPushDownSpec.class, ProjectPushDownSpec.class, PartitionPushDownSpec.class, ReadingMetadataSpec.class});

    private DeltaJoinUtil() {
    }

    public static boolean canConvertToDeltaJoin(StreamPhysicalJoin join) {
        FlinkJoinType flinkJoinType = JoinTypeUtil.getFlinkJoinType(join.getJoinType());
        if (!DeltaJoinUtil.isJoinTypeSupported(flinkJoinType)) {
            return false;
        }
        if (!DeltaJoinUtil.areJoinConditionsSupported(join)) {
            return false;
        }
        if (!DeltaJoinUtil.canJoinOutputDuplicateChanges(join)) {
            return false;
        }
        if (!DeltaJoinUtil.areAllInputsInsertOrUpdateAfter(join)) {
            return false;
        }
        if (!DeltaJoinUtil.areAllJoinInputsInWhiteList(join)) {
            return false;
        }
        if (!DeltaJoinUtil.areAllUpstreamCalcSupported(join)) {
            return false;
        }
        return DeltaJoinUtil.areAllJoinTableScansSupported(join);
    }

    public static RelOptTable getTableScanRelOptTable(RelNode node) {
        return DeltaJoinUtil.getTableScan(node).getTable();
    }

    public static DeltaJoinSpec getDeltaJoinSpec(StreamPhysicalJoin join, boolean treatRightAsLookupSide) {
        IntPair[] streamToLookupJoinKeys;
        RelOptTable lookupRelOptTable;
        Optional<RexProgram> calcOnLookupTable;
        JoinInfo joinInfo = join.analyzeCondition();
        RexBuilder rexBuilder = join.getCluster().getRexBuilder();
        RexNode condition = RexUtil.composeConjunction(rexBuilder, joinInfo.nonEquiConditions);
        Optional<Object> remainingCondition = condition.isAlwaysTrue() ? Optional.empty() : Optional.of(condition);
        List<IntPair> joinPairs = joinInfo.pairs();
        if (treatRightAsLookupSide) {
            calcOnLookupTable = DeltaJoinUtil.getRexProgramBetweenJoinAndTableScan(join.getRight());
            lookupRelOptTable = DeltaJoinUtil.getTableScanRelOptTable(join.getRight());
            streamToLookupJoinKeys = TemporalJoinUtil.getTemporalTableJoinKeyPairs(joinPairs.toArray(new IntPair[0]), JavaScalaConversionUtil.toScala(calcOnLookupTable));
        } else {
            calcOnLookupTable = DeltaJoinUtil.getRexProgramBetweenJoinAndTableScan(join.getLeft());
            joinPairs = DeltaJoinUtil.reverseIntPairs(joinInfo.pairs());
            lookupRelOptTable = DeltaJoinUtil.getTableScanRelOptTable(join.getLeft());
            streamToLookupJoinKeys = TemporalJoinUtil.getTemporalTableJoinKeyPairs(joinPairs.toArray(new IntPair[0]), JavaScalaConversionUtil.toScala(calcOnLookupTable));
        }
        Preconditions.checkState((boolean)(lookupRelOptTable instanceof TableSourceTable));
        TableSourceTable lookupTable = (TableSourceTable)lookupRelOptTable;
        Map<Integer, FunctionCallUtil.FunctionParam> allLookupKeys = DeltaJoinUtil.analyzerDeltaJoinLookupKeys(streamToLookupJoinKeys);
        List projectionOnTemporalTable = null;
        RexNode filterOnTemporalTable = null;
        if (calcOnLookupTable.isPresent()) {
            Tuple2<List<RexNode>, Option<RexNode>> projectionsAndFilter = JavaScalaConversionUtil.toJava(FlinkRexUtil.expandRexProgram(calcOnLookupTable.get()));
            projectionOnTemporalTable = (List)projectionsAndFilter.f0;
            filterOnTemporalTable = JavaScalaConversionUtil.toJava((Option)projectionsAndFilter.f1).orElse(null);
        }
        return new DeltaJoinSpec(new TemporalTableSourceSpec(lookupTable), allLookupKeys, remainingCondition.orElse(null), projectionOnTemporalTable, filterOnTemporalTable);
    }

    public static AsyncTableFunction<?> getUnwrappedAsyncLookupFunction(RelOptTable temporalTable, Collection<Integer> lookupKeys, ClassLoader classLoader) {
        UserDefinedFunction lookupFunction = LookupJoinUtil.getLookupFunction(temporalTable, lookupKeys, classLoader, true, null, false);
        boolean changed = true;
        while (changed) {
            if (lookupFunction instanceof CachingAsyncLookupFunction) {
                lookupFunction = ((CachingAsyncLookupFunction)lookupFunction).getDelegate();
                continue;
            }
            if (lookupFunction instanceof RetryableAsyncLookupFunctionDelegator) {
                lookupFunction = ((RetryableAsyncLookupFunctionDelegator)lookupFunction).getUserLookupFunction();
                continue;
            }
            changed = false;
        }
        if (!(lookupFunction instanceof AsyncTableFunction)) {
            throw new IllegalStateException(String.format("Table [%s] does not support async lookup. If the table supports the option of async lookup joins, add it to the with parameters of the DDL.", String.join((CharSequence)".", temporalTable.getQualifiedName())));
        }
        return (AsyncTableFunction)lookupFunction;
    }

    public static boolean isJoinTypeSupported(FlinkJoinType flinkJoinType) {
        return FlinkJoinType.INNER == flinkJoinType;
    }

    private static Map<Integer, FunctionCallUtil.FunctionParam> analyzerDeltaJoinLookupKeys(IntPair[] streamToLookupJoinKeys) {
        LinkedHashMap<Integer, FunctionCallUtil.FunctionParam> allFieldRefLookupKeys = new LinkedHashMap<Integer, FunctionCallUtil.FunctionParam>();
        for (IntPair intPair : streamToLookupJoinKeys) {
            allFieldRefLookupKeys.put(intPair.target, new FunctionCallUtil.FieldRef(intPair.source));
        }
        return allFieldRefLookupKeys;
    }

    private static List<IntPair> reverseIntPairs(List<IntPair> intPairs) {
        return intPairs.stream().map(pair -> new IntPair(pair.target, pair.source)).collect(Collectors.toList());
    }

    private static int[][] getAllIndexesColumnsFromTableSchema(ResolvedSchema schema) {
        List indexes = schema.getIndexes();
        List columnsOfIndexes = indexes.stream().map(Index::getColumns).collect(Collectors.toList());
        int[][] results = new int[columnsOfIndexes.size()][];
        for (int i = 0; i < columnsOfIndexes.size(); ++i) {
            List fieldNames = schema.getColumnNames();
            results[i] = ((List)columnsOfIndexes.get(i)).stream().mapToInt(fieldNames::indexOf).toArray();
        }
        return results;
    }

    private static boolean areJoinConditionsSupported(StreamPhysicalJoin join) {
        JoinInfo joinInfo = join.analyzeCondition();
        if (joinInfo.pairs().isEmpty()) {
            return false;
        }
        JoinSpec joinSpec = join.joinSpec();
        Optional<RexNode> nonEquiCond = joinSpec.getNonEquiCondition();
        if (nonEquiCond.isPresent() && !DeltaJoinUtil.areAllRexNodeDeterministic(Collections.singletonList(nonEquiCond.get()))) {
            return false;
        }
        ChangelogMode changelogMode = DeltaJoinUtil.getChangelogMode(join);
        if (changelogMode.containsOnly(RowKind.INSERT)) {
            return true;
        }
        if (nonEquiCond.isEmpty()) {
            return true;
        }
        FlinkRelMetadataQuery fmq = FlinkRelMetadataQuery.reuseOrCreate(join.getCluster().getMetadataQuery());
        Set<ImmutableBitSet> upsertKeys = fmq.getUpsertKeys(join);
        return DeltaJoinUtil.isFilterOnOneSetOfUpsertKeys(nonEquiCond.get(), upsertKeys);
    }

    @VisibleForTesting
    protected static boolean isFilterOnOneSetOfUpsertKeys(RexNode filter, @Nullable Set<ImmutableBitSet> upsertKeys) {
        ImmutableBitSet fieldRefIndices = ImmutableBitSet.of(RexNodeExtractor.extractRefInputFields(Collections.singletonList(filter)));
        return upsertKeys != null && upsertKeys.stream().anyMatch(uk -> uk.contains(fieldRefIndices));
    }

    private static boolean areAllJoinTableScansSupported(StreamPhysicalJoin join) {
        List<IntPair> left2RightJoinPairs = JoinUtil.createJoinInfo(join.getLeft(), join.getRight(), join.getCondition(), new ArrayList<Boolean>()).pairs();
        Optional<RexProgram> calcOnLeftLookupTable = DeltaJoinUtil.getRexProgramBetweenJoinAndTableScan(join.getLeft());
        Optional<RexProgram> calcOnRightLookupTable = DeltaJoinUtil.getRexProgramBetweenJoinAndTableScan(join.getRight());
        List<IntPair> right2LeftJoinPair = DeltaJoinUtil.reverseIntPairs(left2RightJoinPairs);
        int[] leftJoinKeyOnLeftLookupTable = Arrays.stream(TemporalJoinUtil.getTemporalTableJoinKeyPairs(right2LeftJoinPair.toArray(new IntPair[0]), JavaScalaConversionUtil.toScala(calcOnLeftLookupTable))).mapToInt(pair -> pair.target).toArray();
        int[] rightJoinKeyOnRightLookupTable = Arrays.stream(TemporalJoinUtil.getTemporalTableJoinKeyPairs(left2RightJoinPairs.toArray(new IntPair[0]), JavaScalaConversionUtil.toScala(calcOnRightLookupTable))).mapToInt(pair -> pair.target).toArray();
        return DeltaJoinUtil.isTableScanSupported(DeltaJoinUtil.getTableScan(join.getLeft()), leftJoinKeyOnLeftLookupTable) && DeltaJoinUtil.isTableScanSupported(DeltaJoinUtil.getTableScan(join.getRight()), rightJoinKeyOnRightLookupTable);
    }

    private static boolean isTableScanSupported(TableScan tableScan, int[] lookupKeys) {
        if (!(tableScan instanceof StreamPhysicalTableSourceScan)) {
            return false;
        }
        TableSourceTable tableSourceTable = ((StreamPhysicalTableSourceScan)tableScan).tableSourceTable();
        if (tableSourceTable.abilitySpecs().length != 0 && !DeltaJoinUtil.areAllSourceAbilitySpecsSupported(tableScan, tableSourceTable.abilitySpecs())) {
            return false;
        }
        DynamicTableSource source = tableSourceTable.tableSource();
        if (!(source instanceof LookupTableSource)) {
            return false;
        }
        Set<Integer> lookupKeySet = Arrays.stream(lookupKeys).boxed().collect(Collectors.toSet());
        if (!DeltaJoinUtil.isLookupKeysContainsIndex(tableSourceTable, lookupKeySet)) {
            return false;
        }
        return LookupJoinUtil.isAsyncLookup(tableSourceTable, lookupKeySet, null, false, false);
    }

    private static boolean isLookupKeysContainsIndex(TableSourceTable tableSourceTable, Set<Integer> lookupKeySet) {
        Set<Integer> lookupKeySetPassThroughProjectPushDownSpec;
        int[][] idxsOfAllIndexes = DeltaJoinUtil.getAllIndexesColumnsFromTableSchema(tableSourceTable.contextResolvedTable().getResolvedSchema());
        if (idxsOfAllIndexes.length == 0) {
            return false;
        }
        Optional<ProjectPushDownSpec> projectPushDownSpec = Arrays.stream(tableSourceTable.abilitySpecs()).filter(spec -> spec instanceof ProjectPushDownSpec).map(spec -> (ProjectPushDownSpec)spec).findFirst();
        if (projectPushDownSpec.isEmpty()) {
            lookupKeySetPassThroughProjectPushDownSpec = lookupKeySet;
        } else {
            HashMap<Integer, Integer> mapOut2InPos = new HashMap<Integer, Integer>();
            int[][] projectedFields = projectPushDownSpec.get().getProjectedFields();
            for (int i = 0; i < projectedFields.length; ++i) {
                int[] projectedField = projectedFields[i];
                if (projectedField.length > 1) continue;
                int input = projectedField[0];
                mapOut2InPos.put(i, input);
            }
            lookupKeySetPassThroughProjectPushDownSpec = lookupKeySet.stream().flatMap(out -> Stream.ofNullable((Integer)mapOut2InPos.get(out))).collect(Collectors.toSet());
        }
        return Arrays.stream(idxsOfAllIndexes).peek(idxsOfIndex -> Preconditions.checkState((((int[])idxsOfIndex).length > 0 ? 1 : 0) != 0)).anyMatch(idxsOfIndex -> Arrays.stream(idxsOfIndex).allMatch(lookupKeySetPassThroughProjectPushDownSpec::contains));
    }

    private static boolean areAllSourceAbilitySpecsSupported(TableScan tableScan, SourceAbilitySpec[] sourceAbilitySpecs) {
        if (!Arrays.stream(sourceAbilitySpecs).allMatch(spec -> ALL_SUPPORTED_ABILITY_SPEC_IN_SOURCE.contains(spec.getClass()))) {
            return false;
        }
        Optional<ReadingMetadataSpec> metadataSpec = Arrays.stream(sourceAbilitySpecs).filter(spec -> spec instanceof ReadingMetadataSpec).map(spec -> (ReadingMetadataSpec)spec).findFirst();
        if (metadataSpec.isPresent() && !metadataSpec.get().getMetadataKeys().isEmpty()) {
            return false;
        }
        Optional<FilterPushDownSpec> filterPushDownSpec = Arrays.stream(sourceAbilitySpecs).filter(spec -> spec instanceof FilterPushDownSpec).map(spec -> (FilterPushDownSpec)spec).findFirst();
        if (filterPushDownSpec.isEmpty()) {
            return true;
        }
        List<RexNode> filtersOnSource = filterPushDownSpec.get().getPredicates();
        if (!DeltaJoinUtil.areAllRexNodeDeterministic(filtersOnSource)) {
            return false;
        }
        ChangelogMode changelogMode = DeltaJoinUtil.getChangelogMode((StreamPhysicalRel)((Object)tableScan));
        if (changelogMode.containsOnly(RowKind.INSERT)) {
            return true;
        }
        FlinkRelMetadataQuery fmq = FlinkRelMetadataQuery.reuseOrCreate(tableScan.getCluster().getMetadataQuery());
        Set<ImmutableBitSet> upsertKeys = fmq.getUpsertKeys(tableScan);
        return filtersOnSource.stream().allMatch(filter -> DeltaJoinUtil.isFilterOnOneSetOfUpsertKeys(filter, upsertKeys));
    }

    private static TableScan getTableScan(RelNode node) {
        if ((node = DeltaJoinUtil.unwrapNode(node, true)) instanceof StreamPhysicalExchange || node instanceof StreamPhysicalDropUpdateBefore || node instanceof StreamPhysicalCalc) {
            return DeltaJoinUtil.getTableScan(node.getInput(0));
        }
        Preconditions.checkState((boolean)(node instanceof TableScan));
        return (TableScan)node;
    }

    private static boolean areAllUpstreamCalcSupported(StreamPhysicalJoin join) {
        return DeltaJoinUtil.areAllUpstreamCalcFromOneJoinInputSupported(join.getLeft()) && DeltaJoinUtil.areAllUpstreamCalcFromOneJoinInputSupported(join.getRight());
    }

    private static boolean areAllUpstreamCalcFromOneJoinInputSupported(RelNode joinInput) {
        List<Calc> calcListFromThisInput = DeltaJoinUtil.collectCalcBetweenJoinAndTableScan(joinInput);
        if (calcListFromThisInput.size() > 1) {
            return false;
        }
        if (calcListFromThisInput.isEmpty()) {
            return true;
        }
        Calc calc = calcListFromThisInput.get(0);
        return DeltaJoinUtil.isCalcSupported(calc);
    }

    private static Optional<Calc> getCalcBetweenJoinAndTableScan(RelNode joinInput) {
        List<Calc> calcListFromLeftInput = DeltaJoinUtil.collectCalcBetweenJoinAndTableScan(joinInput);
        Preconditions.checkState((calcListFromLeftInput.size() <= 1 ? 1 : 0) != 0, (Object)"Should be validated before calling this function");
        if (calcListFromLeftInput.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(calcListFromLeftInput.get(0));
    }

    private static Optional<RexProgram> getRexProgramBetweenJoinAndTableScan(RelNode joinInput) {
        return DeltaJoinUtil.getCalcBetweenJoinAndTableScan(joinInput).map(Calc::getProgram);
    }

    private static List<Calc> collectCalcBetweenJoinAndTableScan(RelNode joinInput) {
        CalcCollector calcCollector = new CalcCollector();
        calcCollector.go(joinInput);
        return calcCollector.collectResult;
    }

    private static boolean isCalcSupported(Calc calc) {
        RexProgram calcProgram = calc.getProgram();
        return calcProgram == null || DeltaJoinUtil.areAllRexNodeDeterministic(calcProgram.getExprList());
    }

    private static boolean areAllRexNodeDeterministic(List<RexNode> rexNodes) {
        return rexNodes.stream().allMatch(RexUtil::isDeterministic);
    }

    private static boolean areAllJoinInputsInWhiteList(RelNode node) {
        for (RelNode input : node.getInputs()) {
            if (!DeltaJoinUtil.isTheNodeInWhiteList(input = DeltaJoinUtil.unwrapNode(input, true))) {
                return false;
            }
            if (DeltaJoinUtil.areAllJoinInputsInWhiteList(input)) continue;
            return false;
        }
        return true;
    }

    private static boolean isTheNodeInWhiteList(RelNode node) {
        Class<?> nodeClazz = node.getClass();
        return ALL_SUPPORTED_DELTA_JOIN_UPSTREAM_NODES.contains(nodeClazz);
    }

    private static boolean canJoinOutputDuplicateChanges(StreamPhysicalJoin join) {
        DuplicateChanges duplicateChanges = DuplicateChangesUtils.getDuplicateChanges(join).orElseThrow(() -> new IllegalStateException(String.format("Unable to derive changelog mode from node %s. This is a bug.", join)));
        return DuplicateChanges.ALLOW.equals((Object)duplicateChanges);
    }

    private static boolean areAllInputsInsertOrUpdateAfter(StreamPhysicalJoin join) {
        for (RelNode input : join.getInputs()) {
            if (DeltaJoinUtil.onlyProduceInsertOrUpdateAfter(DeltaJoinUtil.unwrapNode(input, false))) continue;
            return false;
        }
        return true;
    }

    private static boolean onlyProduceInsertOrUpdateAfter(StreamPhysicalRel node) {
        ChangelogMode changelogMode = DeltaJoinUtil.getChangelogMode(node);
        Set allKinds = changelogMode.getContainedKinds();
        return !allKinds.contains(RowKind.UPDATE_BEFORE) && !allKinds.contains(RowKind.DELETE);
    }

    private static ChangelogMode getChangelogMode(StreamPhysicalRel node) {
        return JavaScalaConversionUtil.toJava(ChangelogPlanUtils.getChangelogMode(node)).orElseThrow(() -> new IllegalStateException(String.format("Unable to derive changelog mode from node %s. This is a bug.", node)));
    }

    private static StreamPhysicalRel unwrapNode(RelNode node, boolean transposeToChildBlock) {
        if (node instanceof HepRelVertex) {
            node = ((HepRelVertex)node).getCurrentRel();
        }
        if (node instanceof StreamPhysicalIntermediateTableScan && transposeToChildBlock) {
            IntermediateRelTable inputBlockOptimizedTree = (IntermediateRelTable)node.getTable();
            Preconditions.checkState((inputBlockOptimizedTree != null ? 1 : 0) != 0);
            node = inputBlockOptimizedTree.relNode();
        }
        return (StreamPhysicalRel)node;
    }

    private static class CalcCollector
    extends RelVisitor {
        private final List<Calc> collectResult = new ArrayList<Calc>();

        private CalcCollector() {
        }

        @Override
        public void visit(RelNode node, int ordinal, @Nullable RelNode parent) {
            node = DeltaJoinUtil.unwrapNode(node, true);
            super.visit(node, ordinal, parent);
            if (node instanceof Calc) {
                this.collectResult.add((Calc)node);
            }
        }
    }
}

