/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.physical.stream;

import java.io.Serializable;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.functions.sql.SqlWindowTableFunction;
import org.apache.flink.table.planner.plan.logical.TimeAttributeWindowingStrategy;
import org.apache.flink.table.planner.plan.metadata.FlinkRelMetadataQuery;
import org.apache.flink.table.planner.plan.nodes.FlinkConventions$;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalCalc;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalExpand;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalWindowTableFunction;
import org.apache.flink.table.planner.plan.rules.physical.stream.ExpandWindowTableFunctionTransposeRule$;
import org.apache.flink.table.planner.plan.trait.RelWindowProperties;
import org.apache.flink.table.planner.plan.utils.WindowUtil$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001Y4Aa\u0003\u0007\u0001?!)q\u0005\u0001C\u0001Q!)1\u0006\u0001C!Y!)\u0001\b\u0001C!s!)a\b\u0001C\u0005\u007f!)1\f\u0001C\u00059\u001e)A\u000e\u0004E\u0001[\u001a)1\u0002\u0004E\u0001]\")qe\u0002C\u0001e\"91o\u0002b\u0001\n\u0003!\bBB;\bA\u0003%\u0011F\u0001\u0014FqB\fg\u000eZ,j]\u0012|w\u000fV1cY\u00164UO\\2uS>tGK]1ogB|7/\u001a*vY\u0016T!!\u0004\b\u0002\rM$(/Z1n\u0015\ty\u0001#\u0001\u0005qQf\u001c\u0018nY1m\u0015\t\t\"#A\u0003sk2,7O\u0003\u0002\u0014)\u0005!\u0001\u000f\\1o\u0015\t)b#A\u0004qY\u0006tg.\u001a:\u000b\u0005]A\u0012!\u0002;bE2,'BA\r\u001b\u0003\u00151G.\u001b8l\u0015\tYB$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002;\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\t\t\u0003C\u0015j\u0011A\t\u0006\u0003'\rR!\u0001\n\u000e\u0002\u000f\r\fGnY5uK&\u0011aE\t\u0002\u000b%\u0016dw\n\u001d;Sk2,\u0017A\u0002\u001fj]&$h\bF\u0001*!\tQ\u0003!D\u0001\r\u0003\u001di\u0017\r^2iKN$\"!L\u001a\u0011\u00059\nT\"A\u0018\u000b\u0003A\nQa]2bY\u0006L!AM\u0018\u0003\u000f\t{w\u000e\\3b]\")AG\u0001a\u0001k\u0005!1-\u00197m!\t\tc'\u0003\u00028E\tq!+\u001a7PaR\u0014V\u000f\\3DC2d\u0017aB8o\u001b\u0006$8\r\u001b\u000b\u0003uu\u0002\"AL\u001e\n\u0005qz#\u0001B+oSRDQ\u0001N\u0002A\u0002U\naBY;jY\u0012tUm^#ya\u0006tG\r\u0006\u0004A\u0011*{u+\u0017\t\u0003\u0003\u001ak\u0011A\u0011\u0006\u0003\u001b\rS!a\u0004#\u000b\u0005\u0015\u0013\u0012!\u00028pI\u0016\u001c\u0018BA$C\u0005Q\u0019FO]3b[BC\u0017p]5dC2,\u0005\u0010]1oI\")\u0011\n\u0002a\u0001\u0001\u00061Q\r\u001f9b]\u0012DQa\u0013\u0003A\u00021\u000bqA\\3x\u0007\u0006d7\r\u0005\u0002B\u001b&\u0011aJ\u0011\u0002\u0013'R\u0014X-Y7QQf\u001c\u0018nY1m\u0007\u0006d7\rC\u0003Q\t\u0001\u0007\u0011+\u0001\nj]B,HOR5fY\u0012\u001c\u0006.\u001b4uS:<\u0007c\u0001\u0018S)&\u00111k\f\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003]UK!AV\u0018\u0003\u0007%sG\u000fC\u0003Y\t\u0001\u0007A+\u0001\u0007oK^$\u0016.\\3GS\u0016dG\rC\u0003[\t\u0001\u0007Q&\u0001\buS6,g)[3mI\u0006#G-\u001a3\u0002)\u001d,G\u000f\u0015:pU\u0016\u001cG/[8o\u001b\u0006\u0004\b/\u001b8h)\u0011\tV,Z4\t\u000by+\u0001\u0019A0\u0002\u0007\u0019l\u0017\u000f\u0005\u0002aG6\t\u0011M\u0003\u0002c%\u0005AQ.\u001a;bI\u0006$\u0018-\u0003\u0002eC\n)b\t\\5oWJ+G.T3uC\u0012\fG/Y)vKJL\b\"\u00024\u0006\u0001\u0004\u0001\u0015!C8mI\u0016C\b/\u00198e\u0011\u0015AW\u00011\u0001j\u00031qWm^,j]\u0012|w\u000f\u0016,G!\t\t%.\u0003\u0002l\u0005\n\t3\u000b\u001e:fC6\u0004\u0006._:jG\u0006dw+\u001b8e_^$\u0016M\u00197f\rVt7\r^5p]\u00061S\t\u001f9b]\u0012<\u0016N\u001c3poR\u000b'\r\\3Gk:\u001cG/[8o)J\fgn\u001d9pg\u0016\u0014V\u000f\\3\u0011\u0005):1CA\u0004p!\tq\u0003/\u0003\u0002r_\t1\u0011I\\=SK\u001a$\u0012!\\\u0001\t\u0013:\u001bF+\u0011(D\u000bV\t\u0011&A\u0005J\u001dN#\u0016IT\"FA\u0001")
public class ExpandWindowTableFunctionTransposeRule
extends RelOptRule {
    public static ExpandWindowTableFunctionTransposeRule INSTANCE() {
        return ExpandWindowTableFunctionTransposeRule$.MODULE$.INSTANCE();
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        FlinkRelMetadataQuery fmq;
        StreamPhysicalExpand expand = (StreamPhysicalExpand)call.rel(0);
        StreamPhysicalCalc calc = (StreamPhysicalCalc)call.rel(1);
        if (WindowUtil$.MODULE$.calcContainsCallsOnWindowColumns(calc, fmq = FlinkRelMetadataQuery.reuseOrCreate(calc.getCluster().getMetadataQuery()))) {
            return false;
        }
        RelWindowProperties expandWindowProps = fmq.getRelWindowProperties(expand);
        return expandWindowProps != null && !expandWindowProps.getWindowStartColumns().isEmpty() && !expandWindowProps.getWindowEndColumns().isEmpty();
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        StreamPhysicalExpand expand = (StreamPhysicalExpand)call.rel(0);
        StreamPhysicalCalc calc = (StreamPhysicalCalc)call.rel(1);
        StreamPhysicalWindowTableFunction windowTVF = (StreamPhysicalWindowTableFunction)call.rel(2);
        RelOptCluster cluster = expand.getCluster();
        FlinkRelMetadataQuery fmq = FlinkRelMetadataQuery.reuseOrCreate(cluster.getMetadataQuery());
        FlinkTypeFactory typeFactory = (FlinkTypeFactory)cluster.getTypeFactory();
        RelNode input = windowTVF.getInput();
        RelDataType inputRowType = input.getRowType();
        RelTraitSet requiredInputTraitSet = input.getTraitSet().replace(FlinkConventions$.MODULE$.STREAM_PHYSICAL());
        RelNode newInput = RelOptRule.convert(input, requiredInputTraitSet);
        ImmutableBitSet windowColumns = fmq.getRelWindowProperties(windowTVF).getWindowColumns();
        Tuple4<RexProgram, int[], Object, Object> tuple4 = WindowUtil$.MODULE$.buildNewProgramWithoutWindowColumns(cluster.getRexBuilder(), calc.getProgram(), inputRowType, windowTVF.windowing().getTimeAttributeIndex(), windowColumns.toArray());
        if (tuple4 == null) {
            throw new MatchError(tuple4);
        }
        RexProgram newProgram = (RexProgram)tuple4._1();
        int[] fieldShifting = (int[])tuple4._2();
        int newTimeField = BoxesRunTime.unboxToInt((Object)tuple4._3());
        boolean timeFieldAdded = BoxesRunTime.unboxToBoolean((Object)tuple4._4());
        Tuple4 tuple42 = new Tuple4((Object)newProgram, (Object)fieldShifting, (Object)BoxesRunTime.boxToInteger((int)newTimeField), (Object)BoxesRunTime.boxToBoolean((boolean)timeFieldAdded));
        RexProgram newProgram2 = (RexProgram)tuple42._1();
        int[] fieldShifting2 = (int[])tuple42._2();
        int newTimeField2 = BoxesRunTime.unboxToInt((Object)tuple42._3());
        boolean timeFieldAdded2 = BoxesRunTime.unboxToBoolean((Object)tuple42._4());
        StreamPhysicalCalc newCalc = new StreamPhysicalCalc(cluster, calc.getTraitSet(), newInput, newProgram2, newProgram2.getOutputRowType());
        StreamPhysicalExpand newExpand = this.buildNewExpand(expand, newCalc, fieldShifting2, newTimeField2, timeFieldAdded2);
        RelDataType newOutputType = SqlWindowTableFunction.inferRowType(typeFactory, newExpand.getRowType(), typeFactory.createFieldTypeFromLogicalType(windowTVF.windowing().getTimeAttributeType()));
        int timeAttributeOnExpand = timeFieldAdded2 ? newExpand.getRowType().getFieldCount() - 1 : newTimeField2;
        TimeAttributeWindowingStrategy newWindowing = new TimeAttributeWindowingStrategy(windowTVF.windowing().getWindow(), windowTVF.windowing().getTimeAttributeType(), timeAttributeOnExpand);
        StreamPhysicalWindowTableFunction newWindowTVF = new StreamPhysicalWindowTableFunction(cluster, windowTVF.getTraitSet(), newExpand, newOutputType, newWindowing);
        int[] projectionMapping = this.getProjectionMapping(fmq, expand, newWindowTVF);
        RexInputRef[] projectExprs = (RexInputRef[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(projectionMapping)).map((Function1 & Serializable & scala.Serializable)x$2 -> ExpandWindowTableFunctionTransposeRule.$anonfun$onMatch$1(newWindowTVF, BoxesRunTime.unboxToInt((Object)x$2)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(RexInputRef.class)));
        RexProgram topRexProgram = RexProgram.create(newWindowTVF.getRowType(), (List<? extends RexNode>)((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])projectExprs)).toList()).asJava()), null, expand.getRowType(), cluster.getRexBuilder());
        StreamPhysicalCalc topCalc = new StreamPhysicalCalc(cluster, expand.getTraitSet(), (RelNode)newWindowTVF, topRexProgram, topRexProgram.getOutputRowType());
        call.transformTo(topCalc);
    }

    private StreamPhysicalExpand buildNewExpand(StreamPhysicalExpand expand, StreamPhysicalCalc newCalc, int[] inputFieldShifting, int newTimeField, boolean timeFieldAdded) {
        RelDataType newInputRowType = newCalc.getRowType();
        int expandIdIndex = expand.expandIdIndex();
        IntRef newExpandIdIndex = IntRef.create((int)-1);
        Buffer newProjects = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(expand.projects()).asScala()).map((Function1 & Serializable & scala.Serializable)exprs -> {
            ArrayBuffer newExprs = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
            IntRef baseOffset = IntRef.create((int)0);
            ((IterableLike)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(exprs).asScala()).zipWithIndex(Buffer$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                ExpandWindowTableFunctionTransposeRule.$anonfun$buildNewExpand$2(inputFieldShifting, newExprs, newInputRowType, baseOffset, expandIdIndex, newExpandIdIndex, x0$1);
                return BoxedUnit.UNIT;
            });
            Object object = timeFieldAdded ? newExprs.$plus$eq((Object)RexInputRef.of(newTimeField, newInputRowType)) : BoxedUnit.UNIT;
            return (List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)newExprs).asJava();
        }, Buffer$.MODULE$.canBuildFrom());
        return new StreamPhysicalExpand(expand.getCluster(), expand.getTraitSet(), newCalc, (List)JavaConverters$.MODULE$.bufferAsJavaListConverter(newProjects).asJava(), newExpandIdIndex.elem);
    }

    private int[] getProjectionMapping(FlinkRelMetadataQuery fmq, StreamPhysicalExpand oldExpand, StreamPhysicalWindowTableFunction newWindowTVF) {
        RelWindowProperties windowProps = fmq.getRelWindowProperties(oldExpand);
        int[] startColumns = windowProps.getWindowStartColumns().toArray();
        int[] endColumns = windowProps.getWindowEndColumns().toArray();
        int[] timeColumns = windowProps.getWindowTimeColumns().toArray();
        int newWindowTimePos = newWindowTVF.getRowType().getFieldCount() - 1;
        int newWindowEndPos = newWindowTVF.getRowType().getFieldCount() - 2;
        int newWindowStartPos = newWindowTVF.getRowType().getFieldCount() - 3;
        IntRef numWindowColumns = IntRef.create((int)0);
        ArrayBuffer projectMapping = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), oldExpand.getRowType().getFieldCount()).foreach((Function1 & Serializable & scala.Serializable)index -> ExpandWindowTableFunctionTransposeRule.$anonfun$getProjectionMapping$1(startColumns, projectMapping, newWindowStartPos, numWindowColumns, endColumns, newWindowEndPos, timeColumns, newWindowTimePos, BoxesRunTime.unboxToInt((Object)index)));
        return (int[])projectMapping.toArray(ClassTag$.MODULE$.Int());
    }

    public static final /* synthetic */ RexInputRef $anonfun$onMatch$1(StreamPhysicalWindowTableFunction newWindowTVF$1, int x$2) {
        return RexInputRef.of(x$2, newWindowTVF$1.getRowType());
    }

    public static final /* synthetic */ void $anonfun$buildNewExpand$2(int[] inputFieldShifting$1, ArrayBuffer newExprs$1, RelDataType newInputRowType$1, IntRef baseOffset$1, int expandIdIndex$1, IntRef newExpandIdIndex$1, Tuple2 x0$1) {
        RexNode ref;
        RexInputRef rexInputRef;
        RexNode ref2;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null && (ref2 = (RexNode)tuple2._1()) instanceof RexInputRef && inputFieldShifting$1[(rexInputRef = (RexInputRef)ref2).getIndex()] < 0) {
            return;
        }
        if (tuple2 != null && (ref = (RexNode)tuple2._1()) instanceof RexInputRef) {
            RexInputRef rexInputRef2 = (RexInputRef)ref;
            int newInputIndex = inputFieldShifting$1[rexInputRef2.getIndex()];
            newExprs$1.$plus$eq((Object)RexInputRef.of(newInputIndex, newInputRowType$1));
            ++baseOffset$1.elem;
            return;
        }
        if (tuple2 != null) {
            RexNode lit = (RexNode)tuple2._1();
            int exprIndex = tuple2._2$mcI$sp();
            if (lit instanceof RexLiteral) {
                RexLiteral rexLiteral = (RexLiteral)lit;
                newExprs$1.$plus$eq((Object)rexLiteral);
                if (exprIndex == expandIdIndex$1) {
                    newExpandIdIndex$1.elem = baseOffset$1.elem;
                }
                ++baseOffset$1.elem;
                return;
            }
        }
        throw new IllegalArgumentException(new StringBuilder(68).append("Expand node should only contain RexInputRef and RexLiteral, but got ").append(tuple2).toString());
    }

    public static final /* synthetic */ Object $anonfun$getProjectionMapping$1(int[] startColumns$1, ArrayBuffer projectMapping$1, int newWindowStartPos$1, IntRef numWindowColumns$1, int[] endColumns$1, int newWindowEndPos$1, int[] timeColumns$1, int newWindowTimePos$1, int index) {
        if (new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(startColumns$1)).contains((Object)BoxesRunTime.boxToInteger((int)index))) {
            projectMapping$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)newWindowStartPos$1));
            ++numWindowColumns$1.elem;
            return BoxedUnit.UNIT;
        }
        if (new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(endColumns$1)).contains((Object)BoxesRunTime.boxToInteger((int)index))) {
            projectMapping$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)newWindowEndPos$1));
            ++numWindowColumns$1.elem;
            return BoxedUnit.UNIT;
        }
        if (new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(timeColumns$1)).contains((Object)BoxesRunTime.boxToInteger((int)index))) {
            projectMapping$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)newWindowTimePos$1));
            ++numWindowColumns$1.elem;
            return BoxedUnit.UNIT;
        }
        return projectMapping$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)(index - numWindowColumns$1.elem)));
    }

    public ExpandWindowTableFunctionTransposeRule() {
        super(RelOptRule.operand(StreamPhysicalExpand.class, RelOptRule.operand(StreamPhysicalCalc.class, RelOptRule.operand(StreamPhysicalWindowTableFunction.class, RelOptRule.any()), new RelOptRuleOperand[0]), new RelOptRuleOperand[0]), "ExpandWindowTableFunctionTransposeRule");
    }
}

