/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinInfo;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.flink.shaded.curator5.org.apache.curator.shaded.com.google.common.collect.Lists;
import org.apache.flink.table.planner.plan.metadata.FlinkRelMetadataQuery;
import org.apache.flink.table.planner.plan.rules.logical.ImmutableJoinDeriveNullFilterRule;
import org.immutables.value.Value;

@Value.Enclosing
public class JoinDeriveNullFilterRule
extends RelRule<JoinDeriveNullFilterRuleConfig> {
    public static final Long JOIN_NULL_FILTER_THRESHOLD = 2000000L;
    public static final JoinDeriveNullFilterRule INSTANCE = JoinDeriveNullFilterRuleConfig.DEFAULT.toRule();

    private JoinDeriveNullFilterRule(JoinDeriveNullFilterRuleConfig config) {
        super(config);
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        Join join = (Join)call.rel(0);
        return join.getJoinType() == JoinRelType.INNER && !join.analyzeCondition().pairs().isEmpty();
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        LogicalJoin join = (LogicalJoin)call.rel(0);
        RelBuilder relBuilder = call.builder();
        RexBuilder rexBuilder = join.getCluster().getRexBuilder();
        FlinkRelMetadataQuery mq = FlinkRelMetadataQuery.reuseOrCreate(join.getCluster().getMetadataQuery());
        JoinInfo joinInfo = join.analyzeCondition();
        RelNode newLeft = this.createIsNotNullFilter(relBuilder, rexBuilder, mq, join.getLeft(), joinInfo.leftKeys);
        RelNode newRight = this.createIsNotNullFilter(relBuilder, rexBuilder, mq, join.getRight(), joinInfo.rightKeys);
        if (newLeft != join.getLeft() || newRight != join.getRight()) {
            RelNode newJoin = join.copy(join.getTraitSet(), (List)Lists.newArrayList((Object[])new RelNode[]{newLeft, newRight}));
            call.transformTo(newJoin);
        }
    }

    private RelNode createIsNotNullFilter(RelBuilder relBuilder, RexBuilder rexBuilder, FlinkRelMetadataQuery mq, RelNode input, ImmutableIntList keys) {
        ArrayList<RexNode> filters = new ArrayList<RexNode>();
        for (int key : keys) {
            Double nullCount = mq.getColumnNullCount(input, key);
            if (nullCount == null || !(nullCount > (double)JOIN_NULL_FILTER_THRESHOLD.longValue())) continue;
            filters.add(relBuilder.call((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, rexBuilder.makeInputRef(input, key)));
        }
        if (!filters.isEmpty()) {
            return relBuilder.push(input).filter(filters).build();
        }
        return input;
    }

    @Value.Immutable(singleton=false)
    public static interface JoinDeriveNullFilterRuleConfig
    extends RelRule.Config {
        public static final JoinDeriveNullFilterRuleConfig DEFAULT = ImmutableJoinDeriveNullFilterRule.JoinDeriveNullFilterRuleConfig.builder().build().withOperandSupplier(b0 -> b0.operand(LogicalJoin.class).anyInputs()).withDescription("JoinDeriveNullFilterRule");

        @Override
        default public JoinDeriveNullFilterRule toRule() {
            return new JoinDeriveNullFilterRule(this);
        }
    }
}

